/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FocusJOptionPane;
import com.limegroup.gnutella.gui.FramedDialog;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.HTMLLabel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.limewire.service.Switch;
import org.limewire.setting.IntSetting;

public final class MessageService {
    public static final int REMEMBER_ANSWER = 1;
    public static final int FORGET_ANSWER = 0;
    private final Map<String, JDialog> _disposableMessageMap = new HashMap<String, JDialog>();
    private static final MessageService INSTANCE = new MessageService();
    private static Component currentVisibleFrame;

    public static MessageService instance() {
        return INSTANCE;
    }

    MessageService() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Messages..."));
    }

    final void showError(String message) {
        FocusJOptionPane.showMessageDialog(MessageService.getParentComponent(), this.getLabel(message), I18n.tr("Error"), 0);
    }

    final void showError(String message, Switch ignore) {
        if (!ignore.getValue()) {
            FocusJOptionPane.showMessageDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), I18n.tr("Error"), 0);
        }
    }

    final void showWarning(String message, Switch ignore) {
        if (!ignore.getValue()) {
            FocusJOptionPane.showMessageDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), I18n.tr("Warning"), 2);
        }
    }

    final void showWarning(String message) {
        FocusJOptionPane.showMessageDialog(MessageService.getParentComponent(), this.getLabel(message), I18n.tr("Warning"), 2);
    }

    public final void showMessage(Component toDisplay) {
        FocusJOptionPane.showMessageDialog(MessageService.getParentComponent(), toDisplay, I18n.tr("Message"), 1);
    }

    final void showMessage(String message) {
        FocusJOptionPane.showMessageDialog(MessageService.getParentComponent(), this.getLabel(message), I18n.tr("Message"), 1);
    }

    final void showMessage(String message, Switch ignore) {
        if (!ignore.getValue()) {
            FocusJOptionPane.showMessageDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), I18n.tr("Message"), 1);
        }
    }

    final void showDisposableMessage(String dialogKey, String message, int msgType) {
        this.showDisposableMessage(dialogKey, message, null, msgType);
    }

    final void showDisposableMessage(String dialogKey, String message, Switch ignore, int msgType) {
        String title;
        switch (msgType) {
            case 0: {
                title = I18n.tr("Error");
                break;
            }
            case 2: {
                title = I18n.tr("Warning");
                break;
            }
            case -1: 
            case 1: {
                title = I18n.tr("Message");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Message Type: " + msgType);
            }
        }
        if (ignore == null || !ignore.getValue()) {
            if (this._disposableMessageMap.containsKey(dialogKey)) {
                JDialog dialog = this._disposableMessageMap.get(dialogKey);
                dialog.toFront();
                dialog.setVisible(true);
            } else {
                Object component = message;
                if (ignore != null) {
                    component = this.doNotDisplayAgainLabel(message, ignore);
                }
                JOptionPane pane = new JOptionPane(component, msgType);
                boolean dispose = false;
                Component parentComponent = MessageService.getParentComponent();
                if (parentComponent == null) {
                    dispose = true;
                    parentComponent = FocusJOptionPane.createFocusComponent();
                }
                JDialog dialog = pane.createDialog(parentComponent, title);
                dialog.setModal(true);
                this._disposableMessageMap.put(dialogKey, dialog);
                dialog.setVisible(true);
                this._disposableMessageMap.remove(dialogKey);
                if (dispose) {
                    ((JFrame)parentComponent).dispose();
                }
            }
        }
    }

    final void hideDisposableMessage(String dialogKey) {
        JDialog dialog = this._disposableMessageMap.get(dialogKey);
        if (dialog != null) {
            dialog.setVisible(false);
            dialog.dispose();
        }
    }

    final void showConfirmMessage(String message) {
        FocusJOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.getLabel(message), I18n.tr("Message"), 1);
    }

    final void showConfirmMessage(String message, Switch ignore) {
        if (!ignore.getValue()) {
            FocusJOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), I18n.tr("Message"), 1);
        }
    }

    final DialogOption showYesNoMessage(String message, DialogOption defaultOption) {
        return this.showYesNoMessage(message, I18n.tr("Message"), defaultOption);
    }

    final DialogOption showYesNoMessage(String message) {
        return this.showYesNoMessage(message, I18n.tr("Message"));
    }

    final int showConfirmListMessage(String message, Object[] listModel, int messageType, ListCellRenderer listRenderer) {
        return this.showConfirmListMessage(message, listModel, messageType, listRenderer, I18n.tr("Message"));
    }

    final int showConfirmListMessage(String message, Object[] listModel, int messageType, ListCellRenderer listRenderer, String title) {
        JList<Object> list = new JList<Object>(listModel);
        list.setVisibleRowCount(5);
        list.setSelectionForeground(list.getForeground());
        list.setSelectionBackground(list.getBackground());
        list.setFocusable(false);
        if (listRenderer != null) {
            list.setCellRenderer(listRenderer);
        }
        Object[] content = new Object[]{new MultiLineLabel(message, 400), Box.createVerticalStrut(6), new JScrollPane(list)};
        return FocusJOptionPane.showConfirmDialog(MessageService.getParentComponent(), content, title, messageType);
    }

    final DialogOption showYesNoMessage(String message, String title) {
        return this.showYesNoMessage(message, title, DialogOption.YES);
    }

    final DialogOption showYesNoMessage(String message, String title, DialogOption defaultOption) {
        int option;
        Object[] options = new String[]{DialogOption.YES.getText(), DialogOption.NO.getText()};
        try {
            option = FocusJOptionPane.showOptionDialog(MessageService.getParentComponent(), this.getLabel(message), title, 0, 2, null, options, defaultOption.getText());
        }
        catch (InternalError ie) {
            option = 1;
        }
        if (option == 0) {
            return DialogOption.YES;
        }
        return DialogOption.NO;
    }

    final DialogOption showYesNoMessage(String message, IntSetting defValue) {
        return this.showYesNoMessage(message, defValue, DialogOption.YES);
    }

    final DialogOption showYesNoMessage(String message, IntSetting defValue, DialogOption defaultOption) {
        int option;
        Object[] options = new String[]{DialogOption.YES.getText(), DialogOption.NO.getText()};
        DialogOption ret = DialogOption.parseInt(defValue.getValue());
        if (ret == DialogOption.YES || ret == DialogOption.NO) {
            return ret;
        }
        try {
            option = FocusJOptionPane.showOptionDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(message, defValue), I18n.tr("Message"), 0, 2, null, options, defaultOption.getText());
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            option = 1;
        }
        catch (InternalError ie) {
            option = 1;
        }
        ret = option == 0 ? DialogOption.YES : DialogOption.NO;
        if (defValue.getValue() == 1) {
            defValue.setValue(ret.toInt());
        } else {
            defValue.setValue(0);
        }
        return ret;
    }

    final DialogOption showYesNoCancelMessage(String message) {
        int option;
        try {
            option = FocusJOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.getLabel(message), I18n.tr("Message"), 1);
        }
        catch (InternalError ie) {
            option = 1;
        }
        if (option == 0) {
            return DialogOption.YES;
        }
        if (option == 1) {
            return DialogOption.NO;
        }
        return DialogOption.CANCEL;
    }

    final DialogOption showYesNoCancelMessage(String message, IntSetting defValue) {
        int option;
        DialogOption ret = DialogOption.parseInt(defValue.getValue());
        if (ret == DialogOption.YES || ret == DialogOption.NO) {
            return ret;
        }
        try {
            option = FocusJOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(message, defValue), I18n.tr("Message"), 1);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            option = 2;
        }
        catch (InternalError ie) {
            option = 2;
        }
        ret = option == 0 ? DialogOption.YES : (option == 1 ? DialogOption.NO : DialogOption.CANCEL);
        if (defValue.getValue() == 1 && ret != DialogOption.CANCEL) {
            defValue.setValue(ret.toInt());
        } else {
            defValue.setValue(0);
        }
        return ret;
    }

    final DialogOption showYesNoOtherMessage(String message, IntSetting defValue, String otherName) {
        int option;
        Object[] options = new String[]{DialogOption.YES.getText(), DialogOption.NO.getText(), otherName};
        DialogOption ret = DialogOption.parseInt(defValue.getValue());
        if (ret == DialogOption.YES || ret == DialogOption.NO) {
            return ret;
        }
        try {
            option = FocusJOptionPane.showOptionDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(message, defValue), I18n.tr("Message"), 0, 2, null, options, DialogOption.YES.getText());
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            option = -1;
        }
        catch (InternalError ie) {
            option = -1;
        }
        ret = option == 0 ? DialogOption.YES : (option == 1 ? DialogOption.NO : (option == 2 ? DialogOption.OTHER : DialogOption.CANCEL));
        if (defValue.getValue() == 1 && ret != DialogOption.OTHER && ret != DialogOption.CANCEL) {
            defValue.setValue(ret.toInt());
        } else {
            defValue.setValue(0);
        }
        return ret;
    }

    public static Component getParentComponent() {
        if (currentVisibleFrame != null) {
            return currentVisibleFrame;
        }
        if (GUIMediator.isOptionsVisible()) {
            return GUIMediator.getMainOptionsComponent();
        }
        if (GUIMediator.isAppVisible()) {
            return GUIMediator.getAppFrame();
        }
        return null;
    }

    private JComponent getLabel(String message) {
        if (message.startsWith("<html")) {
            return new HTMLLabel(message);
        }
        return new MultiLineLabel(message, 400);
    }

    private final JComponent doNotDisplayAgainLabel(String message, final Switch setting) {
        JPanel thePanel = new JPanel(new BorderLayout(0, 15));
        JCheckBox option = new JCheckBox(I18n.tr("Do not display this message again"));
        JComponent lbl = this.getLabel(message);
        thePanel.add((Component)lbl, "North");
        thePanel.add((Component)option, "West");
        option.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                setting.setValue(e.getStateChange() == 1);
            }
        });
        return thePanel;
    }

    private final JComponent alwaysUseThisAnswerLabel(String message, final IntSetting setting) {
        JPanel thePanel = new JPanel(new BorderLayout(0, 15));
        JCheckBox option = new JCheckBox(I18n.tr("Always use this answer"));
        JComponent lbl = this.getLabel(message);
        thePanel.add((Component)lbl, "North");
        thePanel.add((Component)option, "West");
        option.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    setting.setValue(1);
                } else {
                    setting.setValue(0);
                }
            }
        });
        return thePanel;
    }

    public static void setCurrentFrame(FramedDialog dialogFrame) {
        currentVisibleFrame = dialogFrame;
    }
}

