/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Timer;
import org.limewire.inspection.InspectablePrimitive;

public final class RefreshTimer {
    private final int UPDATE_TIME = 1000;
    private final int UPDATE_TIME_IN_SECONDS = 1;
    private Timer _timer;
    @InspectablePrimitive(value="currentUptime")
    private static volatile long currentUptime = 0L;
    private static final int UPTIME_HISTORY_SNAPSHOT_INTERVAL = 60;
    private static final int LAST_N_UPTIMES = 20;
    private final AtomicBoolean firstUtimeUpdate = new AtomicBoolean(true);

    public RefreshTimer() {
        ActionListener refreshGUI = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RefreshTimer.this.refreshGUI();
            }
        };
        this._timer = new Timer(1000, refreshGUI);
    }

    public void startTimer() {
        this._timer.start();
    }

    private void refreshGUI() {
        GUIMediator.instance().refreshGUI();
        int totalUptime = ApplicationSettings.TOTAL_UPTIME.getValue() + 1;
        ApplicationSettings.TOTAL_UPTIME.setValue(totalUptime);
        ApplicationSettings.AVERAGE_UPTIME.setValue(totalUptime / ApplicationSettings.SESSIONS.getValue());
        this.updateUptimeHistory(++currentUptime, 60, 20);
    }

    void updateUptimeHistory(long currentUptime, int interval, int historyLength) {
        if (currentUptime == 0L) {
            return;
        }
        if (currentUptime % (long)interval == 0L) {
            String[] lastNUptimes = ApplicationSettings.LAST_N_UPTIMES.getValue();
            if (this.firstUtimeUpdate.getAndSet(false)) {
                String[] copy;
                if (lastNUptimes.length < historyLength) {
                    copy = new String[lastNUptimes.length + 1];
                    System.arraycopy(lastNUptimes, 0, copy, 0, lastNUptimes.length);
                } else {
                    copy = new String[historyLength];
                    System.arraycopy(lastNUptimes, 1, copy, 0, copy.length - 1);
                }
                copy[copy.length - 1] = Long.toString(currentUptime);
                ApplicationSettings.LAST_N_UPTIMES.setValue(copy);
            } else if (lastNUptimes.length == 0) {
                ApplicationSettings.LAST_N_UPTIMES.setValue(new String[]{Long.toString(currentUptime)});
            } else {
                lastNUptimes[lastNUptimes.length - 1] = Long.toString(currentUptime);
                ApplicationSettings.LAST_N_UPTIMES.setValue(lastNUptimes);
            }
        }
    }
}

