/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.banner.Ad;
import com.limegroup.gnutella.gui.banner.Banner;
import com.limegroup.gnutella.settings.UpdateSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.metal.MetalLabelUI;
import org.limewire.i18n.I18nMarker;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;

final class StatusLinkHandler
implements SettingListener {
    private static final Banner DEFAULT_BANNER = new Banner(I18nMarker.marktr("For Turbo-Charged searches get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&21", "0.111111", I18nMarker.marktr("Support LimeWire's peer-to-peer development. Get PRO."), "http://www.limewire.com/index.jsp/pro&22", "0.111111", I18nMarker.marktr("Purchase LimeWire PRO to help us make downloads faster."), "http://www.limewire.com/index.jsp/pro&23", "0.111111", I18nMarker.marktr("For Turbo-Charged downloads get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&24", "0.111111", I18nMarker.marktr("Support open networks. Get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&25", "0.111111", I18nMarker.marktr("Support open source and open protocols. Get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&26", "0.111111", I18nMarker.marktr("For Turbo-Charged performance get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&27", "0.111111", I18nMarker.marktr("Keep the Internet open. Get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&28", "0.111111", I18nMarker.marktr("Developing LimeWire costs real money. Get PRO."), "http://www.limewire.com/index.jsp/pro&29", "0.111111");
    private Banner ads;
    private final Map<Ad, LabelURLPair> labels = Collections.synchronizedMap(new HashMap());
    private LabelURLPair _curLabel;
    private final JLabel LABEL = new JLabel("", 0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatusLinkHandler() {
        if (GUIMediator.isEnglishLocale()) {
            this.loadLabels();
            UpdateSettings.PRO_ADS.addSettingListener(this);
        }
        Map<Ad, LabelURLPair> map = this.labels;
        synchronized (map) {
            if (this.labels.isEmpty()) {
                this.updateLabels(DEFAULT_BANNER);
            }
            assert (!this.labels.isEmpty()) : "couldn't load any pro banner!";
        }
        this.LABEL.setUI(new LinkLabelUI());
        FontMetrics fm = this.LABEL.getFontMetrics(this.LABEL.getFont());
        int width = fm.stringWidth("123456789/123456789/1");
        Map<Ad, LabelURLPair> map2 = this.labels;
        synchronized (map2) {
            for (LabelURLPair lur : this.labels.values()) {
                width = Math.max(width, fm.stringWidth(lur.getLabel()));
            }
        }
        Dimension dim = new Dimension(width, fm.getHeight());
        this.LABEL.setForeground(Color.blue);
        this.LABEL.setPreferredSize(dim);
        this.LABEL.setMaximumSize(dim);
        this.LABEL.setText(this.getNextLabelURLPair().getLabel());
        this.LABEL.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                StatusLinkHandler.this.handleLinkClick();
            }

            public void mouseEntered(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        });
        if (this.labels.size() > 1) {
            new Timer(30000, new LabelTimerListener()).start();
        }
    }

    public void settingChanged(SettingEvent evt) {
        if (evt.getEventType() != SettingEvent.EventType.VALUE_CHANGED) {
            return;
        }
        this.loadLabels();
    }

    private void loadLabels() {
        try {
            Banner b = new Banner(UpdateSettings.PRO_ADS.getValue());
            this.updateLabels(b);
        }
        catch (IllegalArgumentException bad) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLabels(Banner b) {
        Map<Ad, LabelURLPair> map = this.labels;
        synchronized (map) {
            this.ads = b;
            this.labels.clear();
            for (Ad ad : this.ads.getAllAds()) {
                String text = ad.getText();
                text = I18n.tr(text);
                this.labels.put(ad, new LabelURLPair(text, ad.getURI()));
            }
        }
    }

    Component getComponent() {
        return this.LABEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LabelURLPair getNextLabelURLPair() {
        Map<Ad, LabelURLPair> map = this.labels;
        synchronized (map) {
            this._curLabel = this.labels.get(this.ads.getAd());
        }
        return this._curLabel;
    }

    private void handleLinkChange() {
        String label = this.getNextLabelURLPair().getLabel();
        this.LABEL.setText(label);
        FontMetrics fm = this.LABEL.getFontMetrics(this.LABEL.getFont());
        int width = fm.stringWidth(label);
        int height = fm.getHeight();
        Dimension preferred = new Dimension(width, height);
        this.LABEL.setPreferredSize(preferred);
        GUIMediator.instance().getStatusLine().refresh();
    }

    private void handleLinkClick() {
        GUIMediator.openURL(this._curLabel.getURL());
    }

    private class LinkLabelUI
    extends MetalLabelUI {
        private LinkLabelUI() {
        }

        protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
            super.paintEnabledText(l, g, s, textX, textY);
            if (StatusLinkHandler.this.LABEL.getText() == null) {
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            g.fillRect(textX, fm.getAscent() + 2, fm.stringWidth(StatusLinkHandler.this.LABEL.getText()) - ((StatusLinkHandler)StatusLinkHandler.this).LABEL.getInsets().right, 1);
        }
    }

    private static final class LabelURLPair {
        private final String LABEL_STRING;
        private final String URL;

        private LabelURLPair(String label, String url) {
            this.LABEL_STRING = label;
            this.URL = url;
        }

        private String getLabel() {
            return this.LABEL_STRING;
        }

        private String getURL() {
            return this.URL;
        }
    }

    private class LabelTimerListener
    implements ActionListener {
        private LabelTimerListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StatusLinkHandler.this.handleLinkChange();
        }
    }
}

