/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.TipOfTheDayMessages;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TipOfTheDayMediator
implements ThemeObserver {
    private static final int TIP_HEIGHT = 180;
    private static final int TIP_WIDTH = 360;
    private static TipOfTheDayMediator instance;
    private static final String TOTD_TITLE;
    private static final String TOTD_INTRO;
    private static final String TOTD_STARTUP;
    private static final String TOTD_NEXT;
    private static final String TOTD_PREVIOUS;
    private static final String TOTD_CLOSE;
    private final JDialog dialog;
    private final JEditorPane tipPane = new JEditorPane();
    private final JButton previousButton;
    private final List<String> messages;
    private static int _currentTip;
    private static Color _foreground;
    private boolean _canDisplay = true;

    private TipOfTheDayMediator() {
        this.dialog = new JDialog();
        this.messages = new ArrayList<String>();
        this.initializeMessages(this.messages);
        this.dialog.setModal(false);
        this.dialog.setResizable(true);
        this.dialog.setTitle(TOTD_TITLE);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                instance = null;
            }
        });
        this.previousButton = new JButton(TOTD_PREVIOUS);
        this.previousButton.addActionListener(new PreviousTipListener());
        this.constructDialog();
        ThemeMediator.addThemeObserver(this);
    }

    public static synchronized TipOfTheDayMediator instance() {
        if (instance == null) {
            instance = new TipOfTheDayMediator();
        }
        return instance;
    }

    public static synchronized boolean isConstructed() {
        return instance != null;
    }

    public void updateComponentTreeUI() {
        SwingUtilities.updateComponentTreeUI(this.dialog);
    }

    public void displayTipWindow() {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                if (!TipOfTheDayMediator.this._canDisplay) {
                    return;
                }
                if (TipOfTheDayMediator.this.dialog.isShowing()) {
                    TipOfTheDayMediator.this.dialog.setVisible(false);
                    TipOfTheDayMediator.this.dialog.setVisible(true);
                    TipOfTheDayMediator.this.dialog.toFront();
                    return;
                }
                GUIUtils.centerOnScreen(TipOfTheDayMediator.this.dialog);
                TipOfTheDayMediator.this.dialog.setVisible(true);
                if (!"text/html".equals(TipOfTheDayMediator.this.tipPane.getContentType())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TipOfTheDayMediator.this.tipPane.setContentType("text/html");
                            TipOfTheDayMediator.this.setText(TipOfTheDayMediator.this.getRandomTip());
                        }
                    });
                }
                TipOfTheDayMediator.this.dialog.toFront();
            }
        });
    }

    public void hide() {
        this.dialog.setVisible(false);
    }

    private void setText(String tip) {
        String foreHex = GUIUtils.colorToHex(_foreground);
        this.tipPane.setText("<html><font face='arial,helvetica,sanserif' color='#" + foreHex + "'>" + tip + "</font>");
        this.tipPane.setCaretPosition(0);
    }

    private void initializeMessages(List<String> messages) {
        messages.addAll(Arrays.asList(TipOfTheDayMessages.getGeneralMessages()));
        if (OSUtils.isWindows()) {
            messages.addAll(Arrays.asList(TipOfTheDayMessages.getWindowsMessages()));
        } else if (OSUtils.isMacOSX()) {
            messages.addAll(Arrays.asList(TipOfTheDayMessages.getMacOSXMessages()));
        } else if (OSUtils.isLinux()) {
            messages.addAll(Arrays.asList(TipOfTheDayMessages.getLinuxMessages()));
        } else {
            messages.addAll(Arrays.asList(TipOfTheDayMessages.getOtherMessages()));
        }
        if (!OSUtils.isMacOSX()) {
            messages.addAll(Arrays.asList(TipOfTheDayMessages.getNonMacOSXMessages()));
        }
        if (LimeWireUtils.isPro()) {
            messages.addAll(Arrays.asList(TipOfTheDayMessages.getProMessages()));
        } else {
            messages.addAll(Arrays.asList(TipOfTheDayMessages.getBasicMessages()));
        }
        for (String[] msg : TipOfTheDayMessages.getCustomMessages()) {
            messages.add(TipOfTheDayMessages.buildCustom(msg));
        }
        Collections.shuffle(messages);
        _currentTip = -1;
    }

    private String getRandomTip() {
        if (this.messages.size() == 0) {
            throw new RuntimeException("No tips of the day");
        }
        if (_currentTip == this.messages.size() - 1) {
            Collections.shuffle(this.messages);
            _currentTip = -1;
        } else if (_currentTip < -1) {
            _currentTip = -1;
        }
        String message = this.messages.get(++_currentTip);
        if (_currentTip == 0) {
            this.previousButton.setEnabled(false);
        } else {
            this.previousButton.setEnabled(true);
        }
        return message;
    }

    @Override
    public void updateTheme() {
        boolean wasShowing = this.dialog.isShowing();
        this.dialog.setVisible(false);
        this.dialog.getContentPane().removeAll();
        Font tipFont = new Font(this.tipPane.getFont().getName(), this.tipPane.getFont().getStyle(), this.tipPane.getFont().getSize() - 2);
        this.tipPane.setFont(tipFont);
        this.constructDialog();
        this.tipPane.setContentType("text/html");
        this.setText(this.getRandomTip());
        if (wasShowing) {
            this.dialog.setVisible(true);
            this.dialog.toFront();
        }
    }

    private void constructDialog() {
        Color darkColor = ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue().darker();
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBackground(darkColor);
        centerPanel.setOpaque(true);
        centerPanel.setBorder(BorderFactory.createEtchedBorder(1));
        JLabel iconLabel = new JLabel(GUIMediator.getThemeImage("question"));
        _foreground = iconLabel.getForeground();
        iconLabel.setOpaque(false);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        centerPanel.add((Component)iconLabel, "West");
        JPanel tipPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)tipPanel, "Center");
        tipPanel.setBackground(UIManager.getColor("TextField.background"));
        tipPanel.setOpaque(true);
        JLabel titleLabel = new JLabel(TOTD_INTRO);
        titleLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, darkColor), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        Font titleFont = new Font("Dialog", titleLabel.getFont().getStyle(), titleLabel.getFont().getSize() + 5);
        titleLabel.setFont(titleFont);
        tipPanel.add((Component)titleLabel, "North");
        this.tipPane.setContentType("text");
        this.tipPane.setEditable(false);
        Font tipFont = new Font("Dialog", this.tipPane.getFont().getStyle(), this.tipPane.getFont().getSize() + 2);
        this.tipPane.setFont(tipFont);
        this.tipPane.addHyperlinkListener(GUIUtils.getHyperlinkListener());
        this.tipPane.setText(I18n.tr("Loading tips..."));
        this.tipPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane tipScroller = new JScrollPane(this.tipPane);
        tipScroller.setPreferredSize(new Dimension(360, 180));
        tipScroller.setHorizontalScrollBarPolicy(31);
        tipScroller.setVerticalScrollBarPolicy(20);
        tipScroller.setBorder(null);
        tipPanel.add((Component)tipScroller, "Center");
        JPanel startupPanel = new JPanel(new FlowLayout(0));
        JCheckBox showTips = new JCheckBox(TOTD_STARTUP);
        showTips.setSelected(StartupSettings.SHOW_TOTD.getValue());
        startupPanel.add(showTips);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton next = new JButton(TOTD_NEXT);
        buttonPanel.add(next);
        JButton close = new JButton(TOTD_CLOSE);
        buttonPanel.add(close);
        JPanel navigation = new JPanel(new BorderLayout());
        navigation.add((Component)startupPanel, "West");
        navigation.add((Component)buttonPanel, "East");
        showTips.addActionListener(new ShowTipListener());
        next.addActionListener(new NextTipListener());
        close.addActionListener(GUIUtils.getDisposeAction());
        this.dialog.setDefaultCloseOperation(2);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)centerPanel, "Center");
        contentPanel.add((Component)navigation, "South");
        this.dialog.setContentPane(contentPanel);
        GUIUtils.addHideAction((JComponent)this.dialog.getContentPane());
        try {
            this.dialog.pack();
        }
        catch (OutOfMemoryError oome) {
            this._canDisplay = false;
        }
    }

    static {
        TOTD_TITLE = I18n.tr("Tip of the Day");
        TOTD_INTRO = I18n.tr("Did You Know...");
        TOTD_STARTUP = I18n.tr("Show Tips At Startup");
        TOTD_NEXT = I18n.tr("Next Tip");
        TOTD_PREVIOUS = I18n.tr("Previous Tip");
        TOTD_CLOSE = I18n.tr("Close");
    }

    private class PreviousTipListener
    implements ActionListener {
        private PreviousTipListener() {
        }

        public void actionPerformed(ActionEvent e) {
            _currentTip = _currentTip - 2;
            TipOfTheDayMediator.this.setText(TipOfTheDayMediator.this.getRandomTip());
        }
    }

    private class NextTipListener
    implements ActionListener {
        private NextTipListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TipOfTheDayMediator.this.setText(TipOfTheDayMediator.this.getRandomTip());
        }
    }

    private class ShowTipListener
    implements ActionListener {
        private ShowTipListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBox source = (JCheckBox)e.getSource();
            StartupSettings.SHOW_TOTD.setValue(source.isSelected());
        }
    }
}

