/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Field;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.SystemUtils;

public class TrayPopupMenu
extends JPopupMenu {
    private static final Log LOG = LogFactory.getLog(TrayPopupMenu.class);
    private boolean hackDisabled = false;
    private Field cachedField;

    public void setInvoker(Component invoker) {
        Window anc = SwingUtilities.getWindowAncestor(invoker);
        if (anc != null) {
            SystemUtils.setWindowTopMost(anc);
        }
        super.setInvoker(invoker);
    }

    public void setVisible(boolean b) {
        boolean doHack = false;
        if (b && !this.isVisible()) {
            doHack = true;
        }
        boolean previous = false;
        if (doHack) {
            previous = this.setAdjustmentDisabled(true);
        }
        try {
            super.setVisible(b);
        }
        catch (NullPointerException npe) {
            try {
                super.setVisible(b);
            }
            catch (NullPointerException ignored) {
                // empty catch block
            }
        }
        if (doHack) {
            this.setAdjustmentDisabled(previous);
        }
    }

    private boolean setAdjustmentDisabled(boolean newValue) {
        if (this.hackDisabled) {
            return false;
        }
        try {
            if (this.cachedField == null) {
                this.cachedField = JPopupMenu.class.getDeclaredField("popupPostionFixDisabled");
                this.cachedField.setAccessible(true);
            }
            boolean prior = this.cachedField.getBoolean(null);
            this.cachedField.setBoolean(null, newValue);
            return prior;
        }
        catch (Throwable t) {
            LOG.warn("Unable to do adjustment hack - disabling", t);
            this.hackDisabled = true;
            return false;
        }
    }
}

