/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.startup.ImagePanel;
import com.limegroup.gnutella.gui.startup.StartupAd;
import com.limegroup.gnutella.gui.startup.StartupBanner;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.StartupAdSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

final class UpgradeWindow {
    private JDialog dialog;
    private final BoxPanel MAIN_PANEL = new BoxPanel(1);
    private final ImageIcon defaultBackgroundImage = GUIMediator.getThemeImage("proAdBackground");
    private final Dimension DIALOG_DIMENSION = new Dimension(380, 180);
    private static final Dimension defaultImageSize = new Dimension(361, 108);
    private StartupAd ad = this.loadAd();
    private Action[] actions;
    private final ImagePanel imagePanel;

    public UpgradeWindow() {
        int labelWidth = 240;
        this.dialog = new JDialog(GUIMediator.getAppFrame());
        this.dialog.setModal(true);
        this.dialog.setResizable(true);
        this.dialog.setTitle(this.ad.getTitle() == null ? I18n.tr("Upgrade to PRO") : this.ad.getTitle());
        Border border = BorderFactory.createEmptyBorder(11, 9, 6, 9);
        this.imagePanel = new ImagePanel(this.ad.getMessage() == null ? "" : this.ad.getMessage(), labelWidth);
        ImageIcon image = this.getBackgroundImage();
        if (image != null) {
            this.imagePanel.setBackgroundImage(image.getImage());
            this.imagePanel.setPreferredSize(new Dimension(image.getIconWidth(), image.getIconHeight()));
        } else {
            this.imagePanel.setPreferredSize(defaultImageSize);
        }
        JLabel label2 = new JLabel(this.ad.getButtonMessage());
        label2.setFont(new Font("Dialog", 0, 12));
        BoxPanel questionPanel = new BoxPanel(0);
        questionPanel.add(Box.createVerticalGlue());
        questionPanel.add(label2);
        questionPanel.add(Box.createVerticalGlue());
        this.MAIN_PANEL.setBorder(border);
        this.MAIN_PANEL.setPreferredSize(this.DIALOG_DIMENSION);
        this.dialog.setSize(this.DIALOG_DIMENSION);
        this.actions = new Action[]{new YesAction(0), new WhyAction(1), new NoAction(2)};
        if (StartupAdSettings.PRO_STARTUP_RANDOM_BUTTONS.getValue()) {
            List<Action> shuffled = Arrays.asList(this.actions);
            Collections.shuffle(shuffled);
            this.actions = shuffled.toArray(this.actions);
            for (int i = 0; i < this.actions.length; ++i) {
                LocationAction action = (LocationAction)this.actions[i];
                action.setLocation(i);
            }
        }
        ButtonRow buttons = new ButtonRow(this.actions, 0, 14);
        this.MAIN_PANEL.add(this.imagePanel);
        this.MAIN_PANEL.add(Box.createVerticalStrut(5));
        this.MAIN_PANEL.add(questionPanel);
        this.MAIN_PANEL.add(Box.createVerticalStrut(5));
        this.MAIN_PANEL.add(buttons);
        this.dialog.getContentPane().add(this.MAIN_PANEL);
        this.dialog.pack();
    }

    private ImageIcon getBackgroundImage() {
        if (StartupAdSettings.PRO_STARTUP_REMOTE_IMAGE.getValue()) {
            String url = this.ad.getURLImage();
            if (url == null || url.length() == 0) {
                return this.defaultBackgroundImage;
            }
            BackgroundExecutorService.schedule(new ImageLoader(url, this.defaultBackgroundImage, this.imagePanel));
            return null;
        }
        return this.defaultBackgroundImage;
    }

    private void openURL(String url, int buttonLocation) {
        byte[] guid = GuiCoreMediator.getApplicationServices().getMyGUID();
        GUIMediator.openURL(LimeWireUtils.addLWInfoToUrl(url, guid) + "&button=" + buttonLocation);
    }

    static void showProDialog() {
        UpgradeWindow window = new UpgradeWindow();
        window.dialog.setLocationRelativeTo(GUIMediator.getAppFrame());
        try {
            if (StartupAdSettings.PRO_STARTUP_IS_VISIBLE.getValue()) {
                window.dialog.setVisible(true);
            }
        }
        catch (InternalError internalError) {
            // empty catch block
        }
    }

    private StartupAd loadAd() {
        try {
            StartupBanner b = new StartupBanner(StartupAdSettings.PRO_STARTUP_ADS.getValue());
            return b.getRandomAd();
        }
        catch (IllegalArgumentException bad) {
            return StartupBanner.getDefaultBanner().getRandomAd();
        }
    }

    private static class ImageLoader
    implements Runnable {
        private final String url;
        private final ImageIcon image;
        private final ImagePanel panel;

        public ImageLoader(String url, ImageIcon defaultImage, ImagePanel panel) {
            this.url = url;
            this.image = defaultImage;
            this.panel = panel;
        }

        public void run() {
            ImageIcon icon = new ImageIcon(this.url);
            final ImageIcon displayImage = icon.getIconHeight() <= 0 || icon.getIconWidth() <= 0 || icon.getImage() == null ? this.image : icon;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ImageLoader.this.panel != null && ImageLoader.this.panel.isVisible()) {
                        ImageLoader.this.panel.setBackgroundImage(displayImage.getImage());
                    }
                }
            });
        }
    }

    private abstract class LocationAction
    extends AbstractAction {
        protected int location;

        public LocationAction(int location) {
            this.location = location;
        }

        public void setLocation(int location) {
            this.location = location;
        }
    }

    private class NoAction
    extends LocationAction {
        public NoAction(int location) {
            super(location);
            this.putValue("Name", UpgradeWindow.this.ad.getButton3Text() == null ? I18n.tr("Later") : UpgradeWindow.this.ad.getButton3Text());
            this.putValue("ShortDescription", UpgradeWindow.this.ad.getButton3ToolTip() == null ? I18n.tr("Get LimeWire PRO Later") : UpgradeWindow.this.ad.getButton3ToolTip());
        }

        public void actionPerformed(ActionEvent e) {
            if (UpgradeWindow.this.ad.getURLButton3() != null) {
                UpgradeWindow.this.openURL(UpgradeWindow.this.ad.getURLButton3(), this.location);
            }
            UpgradeWindow.this.dialog.dispose();
            UpgradeWindow.this.dialog.setVisible(false);
        }
    }

    private class WhyAction
    extends LocationAction {
        public WhyAction(int location) {
            super(location);
            this.putValue("Name", UpgradeWindow.this.ad.getButton2Text() == null ? I18n.tr("Why") : UpgradeWindow.this.ad.getButton2Text());
            this.putValue("ShortDescription", UpgradeWindow.this.ad.getButton2ToolTip() == null ? I18n.tr("What does PRO give me?") : UpgradeWindow.this.ad.getButton2ToolTip());
        }

        public void actionPerformed(ActionEvent e) {
            if (UpgradeWindow.this.ad.getURLButton2() != null) {
                UpgradeWindow.this.openURL(UpgradeWindow.this.ad.getURLButton2(), this.location);
            }
            UpgradeWindow.this.dialog.dispose();
            UpgradeWindow.this.dialog.setVisible(false);
        }
    }

    private class YesAction
    extends LocationAction {
        public YesAction(int location) {
            super(location);
            this.putValue("Name", UpgradeWindow.this.ad.getButton1Text() == null ? I18n.tr("Yes") : UpgradeWindow.this.ad.getButton1Text());
            this.putValue("ShortDescription", UpgradeWindow.this.ad.getButton1ToolTip() == null ? I18n.tr("Get LimeWire PRO Now") : UpgradeWindow.this.ad.getButton1ToolTip());
        }

        public void actionPerformed(ActionEvent e) {
            if (UpgradeWindow.this.ad.getURLButton1() != null) {
                UpgradeWindow.this.openURL(UpgradeWindow.this.ad.getURLButton1(), this.location);
            }
            UpgradeWindow.this.dialog.dispose();
            UpgradeWindow.this.dialog.setVisible(false);
        }
    }
}

