/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.google.inject.Singleton;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.actions.LaunchAction;
import com.limegroup.gnutella.gui.actions.ShowInLibraryAction;
import com.limegroup.gnutella.gui.chat.ChatUIManager;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.logging.LogEvent;
import com.limegroup.gnutella.gui.notify.Notification;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.sharing.ShareManager;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.iTunesSettings;
import com.limegroup.gnutella.uploader.UploadType;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.version.UpdateInformation;
import java.io.File;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class VisualConnectionCallback
implements ActivityCallback {
    private final HandleQueryString HANDLE_QUERY_STRING = new HandleQueryString();

    @Override
    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent evt) {
        RoutedConnection c = evt.getConnection();
        if (c != null) {
            Runnable doWorkRunnable;
            if (evt.isConnectionInitializingEvent()) {
                doWorkRunnable = new ConnectionInitializing(c);
            } else if (evt.isConnectionInitializedEvent()) {
                doWorkRunnable = new ConnectionInitialized(c);
            } else if (evt.isConnectionClosedEvent()) {
                doWorkRunnable = new ConnectionClosed(c);
            } else {
                return;
            }
            SwingUtilities.invokeLater(doWorkRunnable);
        }
    }

    @Override
    public void handleQueryString(String query) {
        this.HANDLE_QUERY_STRING.addQueryString(query);
    }

    @Override
    public void handleQueryResult(final RemoteFileDesc rfd, final HostData data, final Set<? extends IpPort> locs) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.handleQueryResult(rfd, data, locs);
            }
        });
    }

    @Override
    public boolean isQueryAlive(GUID guid) {
        return SearchMediator.queryIsAlive(guid);
    }

    @Override
    public void fileManagerLoaded() {
        if (DaapSettings.DAAP_ENABLED.getValue()) {
            Runnable r = new Runnable(){

                public void run() {
                    DaapManager.instance().fileManagerLoaded();
                }
            };
            BackgroundExecutorService.schedule(r);
        }
    }

    @Override
    public void handleSharedFileUpdate(File file) {
        this.mf().getLibraryMediator().updateSharedFile(file);
    }

    @Override
    public void handleFileEvent(final FileManagerEvent evt) {
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                if (DaapSettings.DAAP_ENABLED.getValue() && DaapManager.instance().isEnabled()) {
                    DaapManager.instance().handleFileManagerEvent(evt);
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().handleFileManagerEvent(evt);
            }
        });
    }

    @Override
    public void fileManagerLoading() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().clearLibrary();
            }
        });
        if (DaapSettings.DAAP_ENABLED.getValue()) {
            Runnable r = new Runnable(){

                public void run() {
                    DaapManager.instance().fileManagerLoading();
                }
            };
            BackgroundExecutorService.schedule(r);
        }
    }

    @Override
    public void addDownload(Downloader mgr) {
        AddDownload doWorkRunnable = new AddDownload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    @Override
    public void removeDownload(Downloader mgr) {
        RemoveDownload doWorkRunnable = new RemoveDownload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
        if (iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue() && mgr.getState() == Downloader.DownloadStatus.COMPLETE) {
            iTunesMediator.instance().addSong(mgr.getSaveFile());
        }
    }

    @Override
    public void downloadsComplete() {
        Finalizer.setDownloadsComplete();
    }

    @Override
    public void showDownloads() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
            }
        });
    }

    @Override
    public void addUpload(Uploader uploader) {
        UploadType type = uploader.getUploadType();
        if (!type.isInternal()) {
            SwingUtilities.invokeLater(new AddUpload(uploader));
        } else if (type == UploadType.BROWSE_HOST) {
            SwingUtilities.invokeLater(new BrowseHosted(uploader));
        }
    }

    @Override
    public void removeUpload(Uploader uploader) {
        UploadType type = uploader.getUploadType();
        if (type != null && !type.isInternal()) {
            SwingUtilities.invokeLater(new RemoveUpload(uploader));
        }
    }

    @Override
    public void uploadsComplete() {
        Finalizer.setUploadsComplete();
    }

    @Override
    public void acceptChat(final InstantMessenger chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().acceptChat(chatter);
            }
        });
    }

    @Override
    public void receiveMessage(final InstantMessenger chatter, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().receiveMessage(chatter, message);
            }
        });
    }

    @Override
    public void chatUnavailable(final InstantMessenger chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().chatUnavailable(chatter);
            }
        });
    }

    @Override
    public void chatErrorMessage(final InstantMessenger chatter, final String str) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().chatErrorMessage(chatter, str);
            }
        });
    }

    @Override
    public void handleAddressStateChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GUIMediator.isConstructed()) {
                    SearchMediator.addressChanged();
                }
            }
        });
    }

    public void handleNoInternetConnection() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GUIMediator.isConstructed()) {
                    GUIMediator.disconnected();
                }
            }
        });
    }

    @Override
    public boolean warnAboutSharingSensitiveDirectory(final File dir) {
        final AtomicBoolean bool = new AtomicBoolean(false);
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                bool.set(ShareManager.warnAboutSensitiveDirectory(dir));
            }
        });
        return bool.get();
    }

    @Override
    public void setAnnotateEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().setAnnotateEnabled(enabled);
            }
        });
    }

    @Override
    public void updateAvailable(UpdateInformation update) {
        GUIMediator.instance().showUpdateNotification(update);
    }

    @Override
    public void browseHostFailed(final GUID guid) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.browseHostFailed(guid);
            }
        });
    }

    @Override
    public void promptAboutCorruptDownload(Downloader downloader) {
        final Downloader dloader = downloader;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogOption resp = GUIMediator.showYesNoMessage(I18n.tr("LimeWire has detected a corruption in the file {0}. Do you want to continue the download?", dloader.getSaveFile().getName()), QuestionsHandler.CORRUPT_DOWNLOAD, DialogOption.NO);
                dloader.discardCorruptDownload(resp == DialogOption.NO);
            }
        });
    }

    public boolean promptAboutStopping() {
        DialogOption resp = GUIMediator.showYesNoMessage(I18n.tr("If you stop this upload, the torrent download will stop. Are you sure you want to do this?"), DialogOption.NO);
        return resp == DialogOption.YES;
    }

    public boolean promptAboutSeeding() {
        DialogOption resp = GUIMediator.showYesNoMessage(I18n.tr("This upload is a torrent and it hasn't seeded enough. You should let it upload some more. Are you sure you want to stop it?"), DialogOption.NO);
        return resp == DialogOption.YES;
    }

    @Override
    public void restoreApplication() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.restoreView();
            }
        });
    }

    @Override
    public void componentLoading(final String component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.setSplashScreenString(I18n.tr(component));
            }
        });
    }

    @Override
    public void acceptedIncomingChanged(final boolean status) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().getStatusLine().updateFirewallLabel(status);
            }
        });
    }

    @Override
    public String getHostValue(String key) {
        return I18n.tr(key);
    }

    private MainFrame mf() {
        return GUIMediator.instance().getMainFrame();
    }

    @Override
    public boolean handleMagnets(final MagnetOptions[] magnets) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean oneSearchStarted = false;
                for (int i = 0; i < magnets.length; ++i) {
                    if (magnets[i].isKeywordTopicOnly() && !oneSearchStarted) {
                        String query = QueryUtils.createQueryString(magnets[i].getKeywordTopic());
                        SearchInformation info = SearchInformation.createKeywordSearch(query, null, MediaType.getAnyTypeMediaType());
                        if (SearchMediator.validateInfo(info) != 0) continue;
                        oneSearchStarted = true;
                        SearchMediator.triggerSearch(info);
                        continue;
                    }
                    DownloaderUtils.createDownloader(magnets[i]);
                }
                if (magnets.length > 0) {
                    GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
                }
            }
        });
        return true;
    }

    @Override
    public void handleTorrent(final File torrentFile) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().openTorrent(torrentFile);
            }
        });
    }

    @Override
    public void installationCorrupted() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.showWarning(I18n.tr("<html><b>Your LimeWire may have been corrupted by a virus or trojan!</b><br><br>Please visit <a href=\"http://www.limewire.com/corrupted\">www.limewire.com</a> and download the newest official version of LimeWire.</html>"));
            }
        });
    }

    private class RemoveUpload
    implements Runnable {
        private Uploader mgr;

        public RemoveUpload(Uploader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getUploadMediator().remove(this.mgr);
        }
    }

    private class AddUpload
    implements Runnable {
        private Uploader up;

        public AddUpload(Uploader up) {
            this.up = up;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getUploadMediator().add(this.up);
            VisualConnectionCallback.this.mf().getLoggingMediator().add(new LogEvent(this.up));
        }
    }

    private class BrowseHosted
    implements Runnable {
        private Uploader up;

        public BrowseHosted(Uploader up) {
            this.up = up;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getLoggingMediator().add(new LogEvent(this.up));
        }
    }

    private class RemoveDownload
    implements Runnable {
        private Downloader mgr;

        public RemoveDownload(Downloader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getDownloadMediator().remove(this.mgr);
            VisualConnectionCallback.this.mf().getLibraryMediator().quickRefresh();
            SearchMediator.updateResults();
            VisualConnectionCallback.this.mf().getLoggingMediator().add(new LogEvent(this.mgr));
            if (this.mgr.getState() == Downloader.DownloadStatus.COMPLETE) {
                Action[] actions = null;
                File file = this.mgr.getFile();
                if (file == null) {
                    return;
                }
                actions = new Action[]{new LaunchAction(file), new ShowInLibraryAction(file)};
                Icon icon = this.mgr.getCustomIconDescriptor() == "" ? GUIMediator.getThemeImage("bittorrent_download") : IconManager.instance().getIconForFile(file);
                if (!file.getName().endsWith(".torrent") || !BittorrentSettings.TORRENT_AUTO_START.getValue()) {
                    Notification notification = new Notification(file.getName() + ": " + I18n.tr("Complete"), icon, actions);
                    NotifyUserProxy.instance().showMessage(notification);
                }
            }
        }
    }

    private class AddDownload
    implements Runnable {
        private Downloader mgr;

        public AddDownload(Downloader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getDownloadMediator().add(this.mgr);
        }
    }

    private class HandleQueryString
    implements Runnable {
        private Vector<String> list = new Vector();
        private boolean active = false;

        public void addQueryString(String query) {
            this.list.add(query);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            while (this.list.size() > 0) {
                String query = this.list.elementAt(0);
                this.list.remove(0);
                VisualConnectionCallback.this.mf().getMonitorView().handleQueryString(query);
            }
            this.active = false;
        }
    }

    private class ConnectionClosed
    implements Runnable {
        private RoutedConnection c;

        public ConnectionClosed(RoutedConnection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().remove(this.c);
        }
    }

    private class ConnectionInitialized
    implements Runnable {
        private RoutedConnection c;

        public ConnectionInitialized(RoutedConnection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().update(this.c);
        }
    }

    private class ConnectionInitializing
    implements Runnable {
        private RoutedConnection c;

        public ConnectionInitializing(RoutedConnection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().add(this.c);
        }
    }
}

