/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;

public class BitziLookupAction
extends AbstractAction {
    private static final String BITZI_LOOKUP_URL = "http://bitzi.com/lookup/{0}?ref=limewire";
    FileDetailsProvider provider;

    public BitziLookupAction(FileDetailsProvider provider) {
        this.putValue("Name", I18n.tr("Lookup File with Bitzi"));
        this.provider = provider;
    }

    public void actionPerformed(ActionEvent e) {
        FileDetails[] files = this.provider.getFileDetails();
        if (files.length == 0) {
            return;
        }
        URN urn = files[0].getSHA1Urn();
        if (urn != null) {
            String urnStr = urn.toString();
            int hashstart = 1 + urnStr.indexOf(":", 4);
            String lookupUrl = MessageFormat.format(BITZI_LOOKUP_URL, urnStr.substring(hashstart));
            GUIMediator.openURL(lookupUrl);
        }
    }
}

