/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class CopyMagnetLinkToClipboardAction
extends AbstractAction {
    private FileDetailsProvider provider;

    public CopyMagnetLinkToClipboardAction(FileDetailsProvider provider) {
        this.provider = provider;
        this.putValue("Name", I18n.tr("Copy Magnet Links to Clipboard"));
        this.putValue("ShortDescription", I18n.tr("Copy the Magnet Links of the Selected Files to the Clipboard"));
    }

    public void actionPerformed(ActionEvent e) {
        this.setClipboardString();
    }

    private void setClipboardString() {
        FileDetails[] files = this.provider.getFileDetails();
        StringBuilder buffer = new StringBuilder();
        String sep = System.getProperty("line.separator");
        for (int i = 0; i < files.length; ++i) {
            MagnetOptions magnet;
            if (buffer.length() > 0) {
                buffer.append(sep);
            }
            if (!(magnet = MagnetOptions.createMagnet(files[i])).isDownloadable()) continue;
            buffer.append(magnet.toExternalForm());
        }
        String text = buffer.toString();
        MagnetClipboardListener.getInstance().setCopiedText(text);
        StringSelection sel = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
    }
}

