/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionLifecycleListener;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.ClearableAutoCompleteTextField;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.download.TorrentFileFilter;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import com.limegroup.gnutella.http.URIUtils;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FileMenuActions {
    static final int SPACE = 6;

    private static boolean openMagnetOrTorrent(String userText) {
        MagnetOptions[] magnets = MagnetOptions.parseMagnets(userText);
        if (magnets.length != 0) {
            MagnetClipboardListener.handleMagnets(magnets, false);
            return true;
        }
        File file = new File(userText);
        if (FileMenuActions.isFileSystemPath(file)) {
            if (file.exists()) {
                GUIMediator.instance().openTorrent(file);
                return true;
            }
        } else {
            try {
                String authority;
                URI uri = URIUtils.toURI(userText);
                String scheme = uri.getScheme();
                if (scheme != null && scheme.equalsIgnoreCase("http") && (authority = uri.getAuthority()) != null && authority.length() != 0 && authority.indexOf(32) == -1) {
                    uri = URIUtils.toURI(uri.toString());
                    GUIMediator.instance().openTorrentURI(uri);
                    return true;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isFileSystemPath(File file) {
        return file.isAbsolute();
    }

    public static class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super(I18n.tr("&Close"));
            this.putValue("LongDescription", I18n.tr("Close the Program"));
        }

        public void actionPerformed(ActionEvent e) {
            GUIMediator.close(false);
        }
    }

    public static class OpenMagnetTorrentAction
    extends AbstractAction {
        private JDialog dialog = null;
        private AutoCompleteTextField PATH_FIELD = new ClearableAutoCompleteTextField(34);

        public OpenMagnetTorrentAction() {
            super(I18n.tr("O&pen Magnet or Torrent"));
            this.putValue("LongDescription", I18n.tr("Opens a magnet link or torrent file"));
        }

        public void actionPerformed(ActionEvent e) {
            if (this.dialog == null) {
                this.createDialog();
            }
            this.PATH_FIELD.setText("");
            this.dialog.pack();
            GUIUtils.centerOnScreen(this.dialog);
            this.dialog.setVisible(true);
        }

        private void createDialog() {
            this.dialog = new JDialog(GUIMediator.getAppFrame(), I18n.tr("Open Magnet or Torrent"), true);
            this.dialog.addWindowListener(new OpenDialogWindowAdapter());
            JPanel panel = (JPanel)this.dialog.getContentPane();
            GUIUtils.addHideAction(panel);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            panel.setBorder(new EmptyBorder(12, 6, 6, 6));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 0, 12, 0);
            panel.add((Component)new JLabel(IconManager.instance().getIconForButton("SEARCH_DOWNLOAD")), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 0;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 6, 12, 0);
            panel.add((Component)new MultiLineLabel(I18n.tr("Type a magnet link, or the path or Web address of a torrent file, and LimeWire will download it for you."), true), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            panel.add((Component)new JLabel(I18n.tr("Open:")), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.gridwidth = 0;
            constraints.insets = new Insets(0, 6, 0, 0);
            panel.add((Component)this.PATH_FIELD, constraints);
            ButtonRow row = new ButtonRow(new Action[]{new PasteAction(), new BrowseAction()}, 0, 12);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 0;
            constraints.insets = new Insets(6, 6, 0, 0);
            constraints.anchor = 17;
            panel.add((Component)row, constraints);
            constraints = new GridBagConstraints();
            constraints.fill = 1;
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 0;
            constraints.weighty = 1.0;
            panel.add((Component)new Canvas(), constraints);
            row = new ButtonRow(new Action[]{new OkAction(), new CancelAction()}, 0, 12);
            constraints = new GridBagConstraints();
            constraints.gridx = 4;
            constraints.gridy = 4;
            constraints.insets = new Insets(12, 0, 0, 0);
            constraints.anchor = 13;
            panel.add((Component)row, constraints);
            this.dialog.getRootPane().setDefaultButton(row.getButtonAtIndex(0));
        }

        private class CancelAction
        extends AbstractAction {
            public CancelAction() {
                super(I18n.tr("Cancel"));
            }

            public void actionPerformed(ActionEvent a) {
                GUIUtils.getDisposeAction().actionPerformed(a);
            }
        }

        private class OkAction
        extends AbstractAction {
            public OkAction() {
                super(I18n.tr("OK"));
            }

            public void actionPerformed(ActionEvent a) {
                if (FileMenuActions.openMagnetOrTorrent(OpenMagnetTorrentAction.this.PATH_FIELD.getText())) {
                    OpenMagnetTorrentAction.this.dialog.setVisible(false);
                    OpenMagnetTorrentAction.this.dialog.dispose();
                } else {
                    GUIMediator.showError(I18n.tr("LimeWire cannot open this file or address. Make sure you typed it correctly, and then try again."));
                }
            }
        }

        private class BrowseAction
        extends AbstractAction {
            public BrowseAction() {
                super(I18n.tr("Browse..."));
            }

            public void actionPerformed(ActionEvent a) {
                File file = FileChooserHandler.getInputFile(GUIMediator.getAppFrame(), TorrentFileFilter.INSTANCE);
                if (file != null) {
                    OpenMagnetTorrentAction.this.PATH_FIELD.setText(file.getAbsolutePath());
                }
            }
        }

        private class PasteAction
        extends AbstractAction {
            public PasteAction() {
                super(I18n.tr("Paste"));
            }

            public void actionPerformed(ActionEvent a) {
                OpenMagnetTorrentAction.this.PATH_FIELD.paste();
            }
        }

        private class OpenDialogWindowAdapter
        extends WindowAdapter {
            private OpenDialogWindowAdapter() {
            }

            public void windowOpened(WindowEvent e) {
                OpenMagnetTorrentAction.this.PATH_FIELD.requestFocusInWindow();
            }
        }
    }

    public static class DisconnectAction
    extends AbstractAction {
        private final ConnectionManager manager;

        public DisconnectAction(ConnectionManager manager) {
            super(I18n.tr("D&isconnect"));
            this.putValue("LongDescription", I18n.tr("Disconnect from the Network"));
            this.manager = manager;
            this.setEnabled(manager.isConnected() || manager.isConnecting());
            manager.addEventListener(new ConnectionStateHandler());
        }

        public DisconnectAction() {
            this(GuiCoreMediator.getConnectionManager());
        }

        public void actionPerformed(ActionEvent e) {
            GUIMediator.instance().disconnect();
        }

        private class ConnectionStateHandler
        implements ConnectionLifecycleListener {
            private ConnectionStateHandler() {
            }

            public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent evt) {
                DisconnectAction.this.setEnabled(DisconnectAction.this.manager.isConnected() || DisconnectAction.this.manager.isConnecting());
            }
        }
    }

    public static class ConnectAction
    extends AbstractAction {
        private final ConnectionManager manager;

        public ConnectAction(ConnectionManager manager) {
            super(I18n.tr("C&onnect"));
            this.putValue("LongDescription", I18n.tr("Connect to the Network"));
            this.manager = manager;
            this.setEnabled(!manager.isConnected() && !manager.isConnecting());
            manager.addEventListener(new ConnectionStateHandler());
        }

        public ConnectAction() {
            this(GuiCoreMediator.getConnectionManager());
        }

        public void actionPerformed(ActionEvent e) {
            GUIMediator.instance().connect();
        }

        private class ConnectionStateHandler
        implements ConnectionLifecycleListener {
            private ConnectionStateHandler() {
            }

            public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent evt) {
                ConnectAction.this.setEnabledLater(!ConnectAction.this.manager.isConnected() && !ConnectAction.this.manager.isConnecting());
            }
        }
    }
}

