/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import org.limewire.i18n.I18nMarker;

public class SearchAction
extends AbstractAction {
    private SearchInformation info;

    public SearchAction(String keywords) {
        this(SearchInformation.createKeywordSearch(keywords, null, MediaType.getAnyTypeMediaType()), I18nMarker.marktr("Search for Keywords: {0}"));
    }

    public SearchAction(SearchInformation info) {
        this(info, I18nMarker.marktr("Search for: {0}"));
    }

    public SearchAction(SearchInformation info, String messageKey) {
        this.info = info;
        this.putValue("Name", MessageFormat.format(I18n.tr(messageKey), info.getTitle()));
        if (SearchMediator.validateInfo(info) != 0) {
            throw new IllegalArgumentException("invalid search info: " + info);
        }
    }

    public void actionPerformed(ActionEvent e) {
        SearchMediator.triggerSearch(this.info);
        GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
    }
}

