/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Collections;
import javax.swing.AbstractAction;
import org.limewire.util.I18NConvert;
import org.limewire.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchXMLFieldAction
extends AbstractAction {
    private NameValue<?> displayPair;
    private String name;
    private String value;
    private NamedMediaType nm;

    public SearchXMLFieldAction(NameValue<?> displayPair, String name, String value, NamedMediaType nm) {
        this.displayPair = displayPair;
        this.name = name;
        this.value = value;
        this.nm = nm;
        String formatted = MessageFormat.format(I18n.tr("Search for {0}: {1}"), displayPair.getName(), displayPair.getValue());
        if (formatted.length() > 80) {
            formatted = formatted.substring(0, 80) + "...";
        }
        this.putValue("Name", formatted);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NameValue<String> namValue = new NameValue<String>(this.name, I18NConvert.instance().getNorm(this.value));
        String xml = GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(Collections.singletonList(namValue), this.nm.getSchema().getSchemaURI()).getXMLString();
        SearchMediator.triggerSearch(SearchInformation.createTitledKeywordSearch(QueryUtils.createQueryString(this.value, true), xml, this.nm.getMediaType(), this.displayPair.getName() + ": " + this.displayPair.getValue()));
        GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
    }
}

