/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.banner;

import com.limegroup.gnutella.gui.banner.Ad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Banner {
    private static final Banner DEFAULT_BANNER = new Banner("Only search results with a {0} are official LimeWire communications.", "http://results.limewire.com/officialresults", "1.0f");
    private final List<Ad> ads;

    public Banner(String ... source) {
        if (source.length % 3 != 0) {
            throw new IllegalArgumentException();
        }
        this.ads = new ArrayList<Ad>(source.length / 3);
        for (int i = 0; i < source.length; i += 3) {
            this.ads.add(new Ad(source[i], source[i + 1], Float.valueOf(source[i + 2]).floatValue()));
        }
        Collections.sort(this.ads);
        float total = 0.0f;
        for (Ad ad : this.ads) {
            total += ad.getProbability();
        }
        if ((double)total < 0.9999 || (double)total > 1.0) {
            throw new IllegalArgumentException("wrong probabilities: " + total);
        }
    }

    public Ad getAd() {
        float dice = (float)Math.random();
        float current = 0.0f;
        for (Ad ad : this.ads) {
            if (!((current += ad.getProbability()) >= dice)) continue;
            return ad;
        }
        return this.ads.get(this.ads.size() - 1);
    }

    public Collection<Ad> getAllAds() {
        return Collections.unmodifiableCollection(this.ads);
    }

    public static Banner getDefaultBanner() {
        return DEFAULT_BANNER;
    }
}

