/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.chat;

import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.gui.chat.ChatFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChatUIManager {
    private static final ChatUIManager INSTANCE = new ChatUIManager();
    private Map<InstantMessenger, ChatFrame> _chats = new HashMap<InstantMessenger, ChatFrame>();

    private ChatUIManager() {
    }

    public static ChatUIManager instance() {
        return INSTANCE;
    }

    public ChatFrame acceptChat(InstantMessenger chatter) {
        ChatFrame frame = this.raiseExistingFrame(chatter);
        if (frame != null) {
            this._chats.remove(frame.getChat());
            frame.chatAvailable(chatter);
        } else {
            final ChatFrame newFrame = new ChatFrame(chatter);
            newFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    newFrame.getChat().stop();
                    ChatUIManager.this.removeChat(newFrame.getChat());
                }
            });
            newFrame.setVisible(true);
            frame = newFrame;
        }
        this._chats.put(chatter, frame);
        return frame;
    }

    private ChatFrame raiseExistingFrame(InstantMessenger chatter) {
        for (InstantMessenger c : this._chats.keySet()) {
            if (!c.getHost().equals(chatter.getHost())) continue;
            ChatFrame frame = this._chats.get(c);
            frame.setState(0);
            frame.toFront();
            return frame;
        }
        return null;
    }

    public void removeChat(InstantMessenger chatter) {
        ChatFrame cframe = this._chats.remove(chatter);
        if (cframe != null) {
            cframe.dispose();
            cframe.setVisible(false);
        }
    }

    public void receiveMessage(InstantMessenger chatter, String message) {
        ChatFrame cframe = this._chats.get(chatter);
        if (cframe == null) {
            return;
        }
        cframe.addResponse(message);
    }

    public void chatUnavailable(InstantMessenger chatter) {
        ChatFrame cframe = this._chats.get(chatter);
        if (cframe == null) {
            return;
        }
        cframe.chatUnavailable();
    }

    public void chatErrorMessage(InstantMessenger chatter, String str) {
        ChatFrame cframe = this._chats.get(chatter);
        if (cframe == null) {
            return;
        }
        cframe.displayErrorMessage(str);
    }

    public Collection<ChatFrame> getChatFrames() {
        return this._chats.values();
    }

    public void clear() {
        for (ChatFrame frame : this.getChatFrames()) {
            frame.getChat().stop();
            frame.dispose();
        }
        this._chats.clear();
    }
}

