/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.gui.GUIUtils;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QRPHolder
implements Comparable<QRPHolder> {
    final float _percentFull;
    final int _size;
    final String _string;
    private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();

    public QRPHolder(double percentFull, int size) {
        this._percentFull = (float)percentFull;
        this._size = size;
        this._string = PERCENT_FORMAT.format(percentFull / 100.0) + " / " + GUIUtils.toKilobytes(size);
    }

    @Override
    public int compareTo(QRPHolder other) {
        if (this._percentFull != other._percentFull) {
            return this._percentFull < other._percentFull ? -1 : 1;
        }
        if (this._size != other._size) {
            return this._size < other._size ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        return this._string;
    }

    static {
        PERCENT_FORMAT.setMaximumFractionDigits(2);
        PERCENT_FORMAT.setMinimumFractionDigits(0);
        PERCENT_FORMAT.setGroupingUsed(false);
    }
}

