/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.dnd.MagnetTransferHandler;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import com.limegroup.gnutella.gui.dnd.SharedFilesTransferHandler;
import com.limegroup.gnutella.gui.dnd.TorrentFilesTransferHandler;
import com.limegroup.gnutella.gui.dnd.TorrentURITransferHandler;
import com.limegroup.gnutella.gui.library.LibraryTableTransferable;
import com.limegroup.gnutella.gui.library.LibraryTreeTransferable;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.http.URIUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class DNDUtils {
    public static final List<LimeTransferHandler> DEFAULT_TRANSFER_HANDLERS = Collections.unmodifiableList(Arrays.asList(new MagnetTransferHandler(), new TorrentURITransferHandler(), new TorrentFilesTransferHandler(), new SharedFilesTransferHandler()));
    public static final LimeTransferHandler DEFAULT_TRANSFER_HANDLER = new MulticastTransferHandler(DEFAULT_TRANSFER_HANDLERS);

    public static URI[] getURIs(Transferable transferable) throws UnsupportedFlavorException, IOException {
        String lines = (String)transferable.getTransferData(FileTransferable.URIFlavor);
        StringTokenizer st = new StringTokenizer(lines, System.getProperty("line.separator"));
        ArrayList<URI> uris = new ArrayList<URI>();
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            if (line.length() == 0) continue;
            try {
                URI uri = URIUtils.toURI(line);
                uris.add(uri);
            }
            catch (URISyntaxException e) {}
        }
        return uris.toArray(new URI[uris.size()]);
    }

    public static boolean contains(DataFlavor[] array, DataFlavor flavor) {
        for (int i = 0; i < array.length; ++i) {
            if (!flavor.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFileFlavors(DataFlavor[] flavors) {
        return DNDUtils.contains(flavors, DataFlavor.javaFileListFlavor) || DNDUtils.contains(flavors, FileTransferable.URIFlavor);
    }

    public static boolean containsLibraryFlavors(DataFlavor[] flavors) {
        return DNDUtils.contains(flavors, LibraryTableTransferable.libraryTableTransferable) || DNDUtils.contains(flavors, LibraryTreeTransferable.libraryTreeFlavor) || DNDUtils.contains(flavors, PlaylistMediator.PlaylistTransferable.playlistFlavor);
    }

    public static File[] getFiles(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (DNDUtils.contains(transferable.getTransferDataFlavors(), DataFlavor.javaFileListFlavor)) {
            return ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).toArray(new File[0]);
        }
        if (DNDUtils.contains(transferable.getTransferDataFlavors(), FileTransferable.URIFlavor)) {
            return DNDUtils.getFiles(DNDUtils.getURIs(transferable));
        }
        return new File[0];
    }

    public static File[] getFiles(URI[] uris) {
        ArrayList<File> files = new ArrayList<File>(uris.length);
        for (URI uri : uris) {
            String scheme = uri.getScheme();
            if (!uri.isAbsolute() || scheme == null || !scheme.equalsIgnoreCase("file")) continue;
            String path = uri.getPath();
            files.add(new File(path));
        }
        return files.toArray(new File[files.size()]);
    }
}

