/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.BasicDropTargetListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.UIResource;

public class LimeDropTarget
extends DropTarget
implements UIResource {
    private static DropTargetListener listener;
    private EventListenerList listenerList;

    private static DropTargetListener getDropTargetListener() {
        if (listener == null) {
            listener = new BasicDropTargetListener();
        }
        return listener;
    }

    public LimeDropTarget(JComponent c) {
        this.setComponent(c);
        try {
            super.addDropTargetListener(LimeDropTarget.getDropTargetListener());
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    public void addDropTargetListener(DropTargetListener dtl) throws TooManyListenersException {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DropTargetListener.class, dtl);
    }

    public void removeDropTargetListener(DropTargetListener dtl) {
        if (this.listenerList != null) {
            this.listenerList.remove(DropTargetListener.class, dtl);
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
        super.dragEnter(e);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i + 1]).dragEnter(e);
            }
        }
    }

    public void dragOver(DropTargetDragEvent e) {
        super.dragOver(e);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i + 1]).dragOver(e);
            }
        }
    }

    public void dragExit(DropTargetEvent e) {
        super.dragExit(e);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i + 1]).dragExit(e);
            }
        }
    }

    public void drop(DropTargetDropEvent e) {
        super.drop(e);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i + 1]).drop(e);
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
        super.dropActionChanged(e);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i + 1]).dropActionChanged(e);
            }
        }
    }
}

