/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastTransferHandler
extends LimeTransferHandler {
    private ArrayList<LimeTransferHandler> handlers = new ArrayList();
    private LimeTransferHandler lastTransferer;

    public MulticastTransferHandler() {
    }

    public MulticastTransferHandler(LimeTransferHandler handler) {
        this.handlers.add(handler);
    }

    public MulticastTransferHandler(LimeTransferHandler head, Collection<LimeTransferHandler> tail) {
        this.handlers.add(head);
        this.handlers.addAll(tail);
    }

    public MulticastTransferHandler(Collection<LimeTransferHandler> defaultHandlers) {
        this.handlers.addAll(defaultHandlers);
    }

    public void addTransferHandler(LimeTransferHandler handler) {
        this.handlers.add(handler);
    }

    public void removeTransferHandler(LimeTransferHandler handler) {
        this.handlers.remove(handler);
    }

    private LimeTransferHandler[] getHandlers() {
        return this.handlers.toArray(new LimeTransferHandler[this.handlers.size()]);
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors, DropInfo ddi) {
        if (DNDUtils.containsLibraryFlavors(flavors)) {
            return false;
        }
        for (LimeTransferHandler handler : this.getHandlers()) {
            if (!handler.canImport(c, flavors, ddi)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if (DNDUtils.containsLibraryFlavors(transferFlavors)) {
            return false;
        }
        for (LimeTransferHandler handler : this.getHandlers()) {
            if (!handler.canImport(comp, transferFlavors)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        for (LimeTransferHandler handler : this.getHandlers()) {
            Transferable t = handler.createTransferable(c);
            if (t == null) continue;
            this.lastTransferer = handler;
            return t;
        }
        this.lastTransferer = null;
        return null;
    }

    @Override
    public boolean importData(JComponent c, Transferable t, DropInfo ddi) {
        for (LimeTransferHandler handler : this.getHandlers()) {
            if (!handler.importData(c, t, ddi)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        for (LimeTransferHandler handler : this.getHandlers()) {
            if (!handler.importData(comp, t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent c) {
        int sourceActions = 0;
        for (LimeTransferHandler handler : this.getHandlers()) {
            sourceActions |= handler.getSourceActions(c);
        }
        return sourceActions;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (this.lastTransferer != null) {
            this.lastTransferer.exportDone(source, data, action);
            this.lastTransferer = null;
        }
    }
}

