/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.CheckBoxListPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.library.RecursiveSharingDialog;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedFilesTransferHandler
extends LimeTransferHandler {
    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors, DropInfo ddi) {
        return this.canImport(c, flavors);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return !DNDUtils.containsLibraryFlavors(transferFlavors) && DNDUtils.containsFileFlavors(transferFlavors);
    }

    @Override
    public boolean importData(JComponent c, Transferable t, DropInfo ddi) {
        return this.importData(c, t);
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (!this.canImport(comp, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            File[] files = DNDUtils.getFiles(t);
            if (files.length > 0) {
                return SharedFilesTransferHandler.handleFiles(files);
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean handleFiles(File[] files) {
        RecursiveSharingDialog dialog;
        List<File> filteredFiles = SharedFilesTransferHandler.filterOutSharedFiles(files);
        if (filteredFiles.size() == 0) {
            return false;
        }
        CheckBoxListPanel<File> listPanel = new CheckBoxListPanel<File>(filteredFiles, new FileTextProvider(), false);
        listPanel.getList().setVisibleRowCount(5);
        Object[] content = new Object[]{new MultiLineLabel(I18n.tr("You dropped the following files/folders on LimeWire, please select the ones you would like to share."), 400), Box.createVerticalStrut(6), listPanel, Box.createVerticalStrut(6), new MultiLineLabel(I18n.tr("All folders you select will also have their subfolders shared."), 400)};
        int response = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), content, I18n.tr("Share Dropped Files?"), 2);
        if (response != 0) {
            return false;
        }
        List<File> filesToShare = listPanel.getSelectedElements();
        if (filesToShare.size() == 0) {
            if (QuestionsHandler.HIDE_EMPTY_DROPPED_SHARE_DIALOG.getValue()) {
                return false;
            }
            Object[] options = new Object[]{I18n.tr("Yes, Try Again"), I18n.tr("No, Share Nothing")};
            JCheckBox showAgain = new JCheckBox(I18n.tr("Do not show this message again."));
            Object[] message = new Object[]{new MultiLineLabel(I18n.tr("You clicked OK but did not select any files to be shared. Would you like to try again?"), 400), Box.createVerticalStrut(6), showAgain};
            response = JOptionPane.showOptionDialog(MessageService.getParentComponent(), message, I18n.tr("Warning"), -1, 1, null, options, options[0]);
            QuestionsHandler.HIDE_EMPTY_DROPPED_SHARE_DIALOG.setValue(showAgain.isSelected());
            if (response == 0) {
                return SharedFilesTransferHandler.handleFiles(files);
            }
            return false;
        }
        HashSet<File> dirs = new HashSet<File>();
        final HashSet<File> fileSet = new HashSet<File>();
        final FileManager fileManager = GuiCoreMediator.getFileManager();
        for (File file : filesToShare) {
            if (file.isDirectory()) {
                if (!fileManager.isFolderShareable(file, true)) continue;
                dirs.add(file);
                continue;
            }
            if (!file.exists()) continue;
            fileSet.add(file);
        }
        if (!dirs.isEmpty() && (dialog = new RecursiveSharingDialog((Frame)GUIMediator.getAppFrame(), dirs.toArray(new File[0]))).showChooseDialog(MessageService.getParentComponent()) == RecursiveSharingDialog.State.OK) {
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    fileManager.addSharedFolders(dialog.getRootsToShare(), dialog.getFoldersToExclude());
                }
            });
        }
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                for (File file : fileSet) {
                    fileManager.addFileAlways(file);
                }
            }
        });
        GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
        return true;
    }

    private static List<File> filterOutSharedFiles(File[] files) {
        FileManager fileManager = GuiCoreMediator.getFileManager();
        ArrayList<File> list = new ArrayList<File>(files.length);
        for (File file : files) {
            if (fileManager.isFileShared(file) || fileManager.isFolderShared(file)) continue;
            list.add(file);
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileTextProvider
    implements CheckBoxList.TextProvider<File> {
        private FileTextProvider() {
        }

        @Override
        public String getText(File obj) {
            return obj.getName();
        }

        @Override
        public String getToolTipText(File obj) {
            return obj.getAbsolutePath();
        }

        @Override
        public Icon getIcon(File obj) {
            Icon icon = IconManager.instance().getIconForFile(obj);
            return icon != null ? icon : new GUIUtils.EmptyIcon("", 16, 16);
        }
    }
}

