/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;

public class TorrentFilesTransferHandler
extends LimeTransferHandler {
    public boolean canImport(JComponent c, DataFlavor[] flavors, DropInfo ddi) {
        return this.canImport(c, flavors);
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return DNDUtils.contains(transferFlavors, DataFlavor.javaFileListFlavor) || DNDUtils.contains(transferFlavors, FileTransferable.URIFlavor);
    }

    public boolean importData(JComponent c, Transferable t, DropInfo ddi) {
        return this.importData(c, t);
    }

    public boolean importData(JComponent comp, Transferable t) {
        if (!this.canImport(comp, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            File[] files = DNDUtils.getFiles(t);
            if (files.length > 0 && this.areAllTorrentFiles(files)) {
                for (File file : files) {
                    GUIMediator.instance().openTorrent(file);
                }
                return true;
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    boolean areAllTorrentFiles(File[] files) {
        for (File file : files) {
            if (file.isFile() && file.getName().toLowerCase().endsWith(".torrent")) continue;
            return false;
        }
        return true;
    }
}

