/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.dnd.FileTransfer;
import com.limegroup.gnutella.gui.dnd.LazyFileTransfer;
import com.limegroup.gnutella.gui.download.PriorityHolder;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.CenteredHolder;
import com.limegroup.gnutella.gui.tables.ChatHolder;
import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.limegroup.gnutella.gui.tables.ColoredCellImpl;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameHolderImpl;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.ProgressBarHolder;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.SpeedRenderer;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.awt.Color;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.Icon;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DownloadDataLine
extends AbstractDataLine<Downloader>
implements LazyFileTransfer {
    private static final String QUEUED_STATE = I18n.tr("Queued");
    private static final String CONNECTING_STATE = I18n.tr("Connecting...");
    private static final String CONNECTING_STATE_TRIED_COUNT = I18n.tr("Connecting ({0} hosts tried)...");
    private static final String WAITING_STATE = I18n.tr("Waiting On Busy Hosts");
    private static final String COMPLETE_STATE = I18n.tr("Complete");
    private static final String ABORTED_STATE = I18n.tr("Aborted");
    private static final String FAILED_STATE = I18n.tr("Awaiting Sources");
    private static final String DOWNLOADING_STATE = I18n.tr("Downloading from");
    private static final String LIBRARY_MOVE_FAILED_STATE = I18n.tr("Disk Problem");
    private static final String CORRUPT_FILE_STATE = I18n.tr("File Corrupted");
    private static final String REQUERY_WAITING_STATE_START = I18n.tr("Waiting {0}s for Sources");
    private static final String REQUERY_WAITING_FOR_USER = I18n.tr("Need More Sources");
    private static final String WAITING_FOR_CONNECTIONS_STATE = I18n.tr("Waiting for Stable Connections");
    private static final String REMOTE_QUEUED_STATE = I18n.tr("Waiting in Line, Position");
    private static final String HASHING_STATE = I18n.tr("Verifying File Contents...");
    private static final String SAVING_STATE = I18n.tr("Saving File...");
    private static final String IDENTIFY_CORRUPTION_STATE = I18n.tr("Recovering Corrupted File");
    private static final String PAUSING_STATE = I18n.tr("Pausing...");
    private static final String PAUSED_STATE = I18n.tr("Paused");
    private static final String INVALID_STATE = I18n.tr("Content Removed");
    private static final String RESUMING_STATE = I18n.tr("Resuming...");
    private static final String FETCHING_STATE = I18n.tr("Downloading .torrent file...");
    private static final String AVERAGE_BANDWIDTH = I18n.tr("Average Bandwidth");
    private static final String ALTERNATE_LOCATIONS = I18n.tr("Valid Alternate Locations");
    private static final String INVALID_ALTERNATE_LOCATIONS = I18n.tr("Invalid Alternate Locations");
    private static final String STARTED_ON = I18n.tr("Started On");
    private static final String FINISHED_ON = I18n.tr("Finished On");
    private static final String TIME_SPENT = I18n.tr("Time Spent");
    private static final String CHUNKS = I18n.tr("Chunks");
    private static final String LOST = I18n.tr("Lost To Corruption");
    private static final String KB = I18n.tr("KB");
    private static final String HOSTS_LABEL = I18n.tr("hosts");
    private static final String HOST_LABEL = I18n.tr("host");
    private static final String[] GAVE_UP_MESSAGE = new String[]{I18n.tr("A more specific search may be required...")};
    private static final String[] INVALID_MESSAGE = new String[]{I18n.tr("The owner of this content has requested that this file be removed from the network. To learn more, double-click on the download (or click preview).")};
    private static final String POSSIBLE_HOSTS = I18n.tr("Possible Hosts");
    private static final String BUSY_HOSTS = I18n.tr("Busy Hosts");
    private static final String QUEUED_HOSTS = I18n.tr("Remotely Queued");
    private static final String DOWNLOAD_SEARCHING = I18n.tr("Locating Sources...");
    private static final String TRACKER_FAILURE_REASON = I18n.tr("LimeWire cannot download this torrent.  The tracker responded");
    private String _fileName;
    private String _status;
    private long _amountRead = 0L;
    private int _progress;
    private boolean _chatEnabled;
    private boolean _browseEnabled;
    private long _size = -1L;
    private double _speed;
    private int _timeLeft;
    private long _startTime;
    private long _endTime;
    private String _vendor;
    private Downloader.DownloadStatus _state;
    private boolean _cleaned = false;
    private Color _cellColor;
    private Color _othercellColor;
    static final int PRIORITY_INDEX = 0;
    private static final LimeTableColumn PRIORITY_COLUMN = new LimeTableColumn(0, "DOWNLOAD_PRIORITY_COLUMN", I18n.tr("Priority"), 40, false, CenteredHolder.class);
    static final int FILE_INDEX = 1;
    private static final LimeTableColumn FILE_COLUMN = new LimeTableColumn(1, "DOWNLOAD_NAME_COLUMN", I18n.tr("Name"), 201, true, ColoredCell.class);
    static final int SIZE_INDEX = 2;
    private static final LimeTableColumn SIZE_COLUMN = new LimeTableColumn(2, "DOWNLOAD_SIZE_COLUMN", I18n.tr("Size"), 65, true, SizeHolder.class);
    static final int STATUS_INDEX = 3;
    private static final LimeTableColumn STATUS_COLUMN = new LimeTableColumn(3, "DOWNLOAD_STATUS_COLUMN", I18n.tr("Status"), 152, true, String.class);
    static final int CHAT_INDEX = 4;
    private static final LimeTableColumn CHAT_COLUMN = new LimeTableColumn(4, "DOWNLOAD_CHAT_COLUMN", I18n.tr("Chat"), 10, false, ChatHolder.class);
    static final int PROGRESS_INDEX = 5;
    private static final LimeTableColumn PROGRESS_COLUMN = new LimeTableColumn(5, "DOWNLOAD_PROGRESS_COLUMN", I18n.tr("Progress"), 71, true, ProgressBarHolder.class);
    static final int SPEED_INDEX = 6;
    private static final LimeTableColumn SPEED_COLUMN = new LimeTableColumn(6, "DOWNLOAD_SPEED_COLUMN", I18n.tr("Speed"), 58, true, SpeedRenderer.class);
    static final int TIME_INDEX = 7;
    private static final LimeTableColumn TIME_COLUMN = new LimeTableColumn(7, "DOWNLOAD_TIME_REMAINING_COLUMN", I18n.tr("Time"), 49, true, TimeRemainingHolder.class);
    static final int VENDOR_INDEX = 8;
    private static final LimeTableColumn VENDOR_COLUMN = new LimeTableColumn(8, "DOWNLOAD_SERVER_COLUMN", I18n.tr("Vendor/Version"), 20, false, String.class);
    static final int NUMBER_OF_COLUMNS = 9;

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public void initialize(Downloader downloader) {
        super.initialize(downloader);
        this._startTime = System.currentTimeMillis();
        this._endTime = -1L;
        this._size = ((Downloader)this.initializer).getContentLength();
        this._fileName = ((Downloader)this.initializer).getSaveFile().getName();
        if (this._fileName == null) {
            this._fileName = "";
        }
        this._status = "";
        this._chatEnabled = false;
        this._browseEnabled = false;
        this.initColors();
        this.update();
    }

    @Override
    public void cleanup() {
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                ((Downloader)DownloadDataLine.this.initializer).stop();
            }
        });
        this._cleaned = true;
    }

    public boolean isCleaned() {
        return this._cleaned;
    }

    public File getFile() {
        if (!OSUtils.isWindows()) {
            return ((Downloader)this.initializer).getFile();
        }
        if (((Downloader)this.initializer).isCompleted()) {
            return ((Downloader)this.initializer).getFile();
        }
        return null;
    }

    @Override
    public FileTransfer getFileTransfer() {
        return new FileTransfer(){

            public File getFile() {
                return ((Downloader)DownloadDataLine.this.initializer).getDownloadFragment();
            }
        };
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                if (((Downloader)this.initializer).isPaused()) {
                    return PriorityHolder.PAUSED_P;
                }
                if (((Downloader)this.initializer).isInactive()) {
                    return new PriorityHolder(((Downloader)this.initializer).getInactivePriority());
                }
                if (((Downloader)this.initializer).isCompleted()) {
                    return PriorityHolder.COMPLETE_P;
                }
                return PriorityHolder.ACTIVE_P;
            }
            case 1: {
                PlayListItem currentPlaying = MediaPlayerComponent.getInstance().getCurrentSong();
                Color color = currentPlaying == null ? this.getColor(false) : this.getColor(currentPlaying.getName().contains(this._fileName));
                return new ColoredCellImpl(new IconAndNameHolderImpl(this.getIcon(), this._fileName), color, IconAndNameHolder.class);
            }
            case 2: {
                return new SizeHolder(this._size);
            }
            case 3: {
                return this._status;
            }
            case 4: {
                return this._chatEnabled ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this._progress;
            }
            case 6: {
                return new Double(this._speed);
            }
            case 7: {
                return new TimeRemainingHolder(this._timeLeft);
            }
            case 8: {
                return this._vendor;
            }
        }
        return null;
    }

    @Override
    public LimeTableColumn getColumn(int idx) {
        switch (idx) {
            case 0: {
                return PRIORITY_COLUMN;
            }
            case 1: {
                return FILE_COLUMN;
            }
            case 2: {
                return SIZE_COLUMN;
            }
            case 3: {
                return STATUS_COLUMN;
            }
            case 4: {
                return CHAT_COLUMN;
            }
            case 5: {
                return PROGRESS_COLUMN;
            }
            case 6: {
                return SPEED_COLUMN;
            }
            case 7: {
                return TIME_COLUMN;
            }
            case 8: {
                return VENDOR_COLUMN;
            }
        }
        return null;
    }

    @Override
    public boolean isClippable(int idx) {
        switch (idx) {
            case 4: 
            case 5: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTypeAheadColumn() {
        return 1;
    }

    @Override
    public boolean isTooltipRequired(int col) {
        return this._state == Downloader.DownloadStatus.INVALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getToolTipArray(int col) {
        String lost;
        String custom;
        if (this._state == Downloader.DownloadStatus.GAVE_UP) {
            return GAVE_UP_MESSAGE;
        }
        if (this._state == Downloader.DownloadStatus.INVALID) {
            return INVALID_MESSAGE;
        }
        if (this._state == Downloader.DownloadStatus.WAITING_FOR_USER && (custom = (String)((Downloader)this.initializer).getAttribute("CIK")) != null) {
            return new String[]{TRACKER_FAILURE_REASON, custom};
        }
        String[] info = new String[11];
        String bandwidth = AVERAGE_BANDWIDTH + ": " + GUIUtils.rate2speed(((Downloader)this.initializer).getAverageBandwidth());
        String numHosts = POSSIBLE_HOSTS + ": " + ((Downloader)this.initializer).getPossibleHostCount();
        String busyHosts = BUSY_HOSTS + ": " + ((Downloader)this.initializer).getBusyHostCount();
        String queuedHosts = QUEUED_HOSTS + ": " + ((Downloader)this.initializer).getQueuedHostCount();
        String numLocs = ALTERNATE_LOCATIONS + ": " + ((Downloader)this.initializer).getNumberOfAlternateLocations();
        String numInvalidLocs = INVALID_ALTERNATE_LOCATIONS + ": " + ((Downloader)this.initializer).getNumberOfInvalidAlternateLocations();
        int chunkSize = 0;
        String numChunks = null;
        int totalPending = GuiCoreMediator.getDiskController().getNumPendingItems();
        Downloader downloader = (Downloader)this.initializer;
        synchronized (downloader) {
            if (this._endTime == -1L) {
                chunkSize = ((Downloader)this.initializer).getChunkSize();
                numChunks = CHUNKS + ": " + ((Downloader)this.initializer).getAmountVerified() / (long)chunkSize + "/" + ((Downloader)this.initializer).getAmountRead() / (long)chunkSize + "[" + ((Downloader)this.initializer).getAmountPending() + "|" + totalPending + "]" + "/" + ((Downloader)this.initializer).getContentLength() / (long)chunkSize + ", " + chunkSize / 1024 + KB;
            }
            lost = LOST + ": " + ((Downloader)this.initializer).getAmountLost() / 1024L + KB;
        }
        info[0] = STARTED_ON + " " + GUIUtils.msec2DateTime(this._startTime);
        if (this._endTime != -1L) {
            info[1] = FINISHED_ON + " " + GUIUtils.msec2DateTime(this._endTime);
            info[2] = TIME_SPENT + ": " + CommonUtils.seconds2time((int)((this._endTime - this._startTime) / 1000L));
            info[3] = "";
            info[4] = bandwidth;
            info[5] = numHosts;
            info[6] = busyHosts;
            info[7] = queuedHosts;
            info[8] = numLocs;
            info[9] = numInvalidLocs;
            info[10] = lost;
        } else {
            info[1] = TIME_SPENT + ": " + CommonUtils.seconds2time((int)((System.currentTimeMillis() - this._startTime) / 1000L));
            info[2] = "";
            info[3] = bandwidth;
            info[4] = numHosts;
            info[5] = busyHosts;
            info[6] = queuedHosts;
            info[7] = numLocs;
            info[8] = numInvalidLocs;
            info[9] = numChunks;
            info[10] = lost;
        }
        return info;
    }

    @Override
    public boolean isDynamic(int idx) {
        switch (idx) {
            case 0: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    long getLength() {
        return this._size;
    }

    public String getFileName() {
        return this._fileName;
    }

    boolean containsDownloader(Downloader downloader) {
        return ((Downloader)this.initializer).equals(downloader);
    }

    Downloader getDownloader() {
        return (Downloader)this.initializer;
    }

    Downloader.DownloadStatus getState() {
        return this._state;
    }

    double getSpeed() {
        return this._speed;
    }

    boolean isCompleted() {
        return this._state == Downloader.DownloadStatus.COMPLETE;
    }

    boolean getChatEnabled() {
        return this._chatEnabled;
    }

    boolean getBrowseEnabled() {
        return this._browseEnabled;
    }

    private Icon getIcon() {
        if (((Downloader)this.initializer).getCustomIconDescriptor() == "") {
            return GUIMediator.getThemeImage("bittorrent_download");
        }
        return IconManager.instance().getIconForFile(((Downloader)this.initializer).getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        Downloader downloader = (Downloader)this.initializer;
        synchronized (downloader) {
            this._fileName = ((Downloader)this.initializer).getSaveFile().getName();
            this._speed = -1.0;
            this._size = ((Downloader)this.initializer).getContentLength();
            this._amountRead = ((Downloader)this.initializer).getAmountRead();
            this._chatEnabled = ((Downloader)this.initializer).hasChatEnabledHost();
            this._browseEnabled = ((Downloader)this.initializer).hasBrowseEnabledHost();
            this._timeLeft = 0;
            double d = (double)this._amountRead / (double)this._size;
            this._progress = (int)(d * 100.0);
            this.updateStatus();
            if (!this.isInactive()) {
                this._endTime = -1L;
            }
        }
    }

    private void updateStatus() {
        String lastVendor = this._vendor;
        this._vendor = "";
        this._state = ((Downloader)this.initializer).getState();
        boolean paused = ((Downloader)this.initializer).isPaused();
        if (paused && this._state != Downloader.DownloadStatus.PAUSED && !((Downloader)this.initializer).isCompleted()) {
            this._status = PAUSING_STATE;
            return;
        }
        switch (this._state) {
            case QUEUED: {
                this._status = QUEUED_STATE;
                break;
            }
            case CONNECTING: {
                int triedCount = ((Downloader)this.initializer).getTriedHostCount();
                if (triedCount < 15) {
                    this._status = CONNECTING_STATE;
                    break;
                }
                this._status = MessageFormat.format(CONNECTING_STATE_TRIED_COUNT, triedCount);
                break;
            }
            case BUSY: {
                this._status = WAITING_STATE;
                break;
            }
            case HASHING: {
                this._status = HASHING_STATE;
                break;
            }
            case SAVING: {
                this._status = SAVING_STATE;
                break;
            }
            case COMPLETE: {
                this._status = COMPLETE_STATE;
                this._progress = 100;
                break;
            }
            case ABORTED: {
                this._status = ABORTED_STATE;
                break;
            }
            case GAVE_UP: {
                this._status = FAILED_STATE;
                break;
            }
            case IDENTIFY_CORRUPTION: {
                this._status = IDENTIFY_CORRUPTION_STATE;
                break;
            }
            case RECOVERY_FAILED: {
                this._status = "Recovery Failed";
                break;
            }
            case DOWNLOADING: {
                this._vendor = lastVendor;
                this.updateHostCount((Downloader)this.initializer);
                try {
                    this._speed = ((Downloader)this.initializer).getMeasuredBandwidth();
                }
                catch (InsufficientDataException ide) {
                    this._speed = 0.0;
                }
                if (!(this._speed > 0.0)) break;
                double kbLeft = (double)this._size / 1024.0 - (double)this._amountRead / 1024.0;
                this._timeLeft = (int)(kbLeft / this._speed);
                break;
            }
            case DISK_PROBLEM: {
                this._status = LIBRARY_MOVE_FAILED_STATE;
                this._progress = 100;
                break;
            }
            case CORRUPT_FILE: {
                this._status = CORRUPT_FILE_STATE;
                break;
            }
            case WAITING_FOR_GNET_RESULTS: {
                int stateTime = ((Downloader)this.initializer).getRemainingStateTime();
                this._status = MessageFormat.format(REQUERY_WAITING_STATE_START, stateTime);
                break;
            }
            case ITERATIVE_GUESSING: 
            case QUERYING_DHT: {
                this._status = DOWNLOAD_SEARCHING;
                break;
            }
            case WAITING_FOR_USER: {
                this._status = REQUERY_WAITING_FOR_USER;
                break;
            }
            case WAITING_FOR_CONNECTIONS: {
                this._status = WAITING_FOR_CONNECTIONS_STATE;
                break;
            }
            case REMOTE_QUEUED: {
                this._status = REMOTE_QUEUED_STATE + " " + ((Downloader)this.initializer).getQueuePosition();
                this._vendor = ((Downloader)this.initializer).getVendor();
                this.updateVendor();
                break;
            }
            case PAUSED: {
                this._status = PAUSED_STATE;
                break;
            }
            case INVALID: {
                this._status = INVALID_STATE;
                break;
            }
            case RESUMING: {
                this._status = RESUMING_STATE;
                break;
            }
            case FETCHING: {
                this._status = FETCHING_STATE;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown status " + (Object)((Object)((Downloader)this.initializer).getState()) + " of downloader");
            }
        }
    }

    private void updateHostCount(Downloader d) {
        int count = d.getNumHosts();
        if (count == 0) {
            return;
        }
        if (count == 1) {
            this._status = DOWNLOADING_STATE + " " + count + " " + HOST_LABEL;
            this._vendor = d.getVendor();
        } else {
            this._status = DOWNLOADING_STATE + " " + count + " " + HOSTS_LABEL;
            this._vendor = d.getVendor();
        }
        this.updateVendor();
    }

    private void updateVendor() {
        if (this._vendor == "") {
            this._vendor = I18n.tr("BitTorrent");
        }
    }

    boolean isInactive() {
        return this._state == Downloader.DownloadStatus.COMPLETE || this._state == Downloader.DownloadStatus.ABORTED || this._state == Downloader.DownloadStatus.GAVE_UP || this._state == Downloader.DownloadStatus.DISK_PROBLEM || this._state == Downloader.DownloadStatus.CORRUPT_FILE;
    }

    boolean isDownloaderInactive() {
        return ((Downloader)this.initializer).isInactive();
    }

    boolean isDownloading() {
        return this._state == Downloader.DownloadStatus.DOWNLOADING;
    }

    void setEndTime(long time) {
        this._endTime = time;
    }

    private void initColors() {
        this._cellColor = ThemeFileHandler.WINDOW8_COLOR.getValue();
        this._othercellColor = ThemeFileHandler.SEARCH_RESULT_SPEED_COLOR.getValue();
    }

    private Color getColor(boolean playing) {
        return playing ? this._othercellColor : this._cellColor;
    }
}

