/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.gui.download.DownloadDataLine;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DownloadModel
extends BasicDataLineModel<DownloadDataLine, Downloader> {
    DownloadModel() {
        super(DownloadDataLine.class);
    }

    @Override
    public DownloadDataLine createDataLine() {
        return new DownloadDataLine();
    }

    int countActiveDownloads() {
        int size = this.getRowCount();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            DownloadDataLine ud = (DownloadDataLine)this.get(i);
            if (ud.isInactive()) continue;
            ++count;
        }
        return count;
    }

    int getCurrentDownloads() {
        int size = this.getRowCount();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            DownloadDataLine dd = (DownloadDataLine)this.get(i);
            if (!dd.isDownloading()) continue;
            ++count;
        }
        return count;
    }

    double getActiveDownloadsBandwidth() {
        int size = this.getRowCount();
        double count = 0.0;
        for (int i = 0; i < size; ++i) {
            DownloadDataLine dd = (DownloadDataLine)this.get(i);
            if (dd.isInactive()) continue;
            count += Math.max(dd.getSpeed(), 0.0);
        }
        return count;
    }

    @Override
    public Object refresh() {
        int size = this.getRowCount();
        boolean inactiveDownloadPresent = false;
        for (int i = 0; i < size; ++i) {
            DownloadDataLine ud = (DownloadDataLine)this.get(i);
            ud.update();
            inactiveDownloadPresent |= ud.isInactive();
        }
        this.fireTableRowsUpdated(0, size);
        return inactiveDownloadPresent ? Boolean.TRUE : Boolean.FALSE;
    }

    void clearCompleted() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            DownloadDataLine line = (DownloadDataLine)this.get(i);
            if (!line.isInactive()) continue;
            this.remove(i);
            if (line.getState() != Downloader.DownloadStatus.GAVE_UP) continue;
            line.cleanup();
        }
    }
}

