/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.download.DownloaderDialog;
import com.limegroup.gnutella.gui.download.GuiDownloaderFactory;
import com.limegroup.gnutella.gui.download.MagnetDownloaderFactory;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.OSUtils;

public class DownloaderUtils {
    public static Downloader createDownloader(GuiDownloaderFactory factory) {
        if (DownloaderUtils.isAlreadyDownloading(factory)) {
            return null;
        }
        if (!DownloaderUtils.isSaveLocationTaken(factory) && !DownloaderUtils.continueWithOrWithoutHashConflict(factory)) {
            return null;
        }
        return DownloaderUtils.createDownloader(factory, false);
    }

    public static Downloader createDownloaderAs(GuiDownloaderFactory factory) {
        if (DownloaderUtils.isAlreadyDownloading(factory)) {
            return null;
        }
        if (!DownloaderUtils.continueWithOrWithoutHashConflict(factory)) {
            return null;
        }
        File file = DownloaderUtils.showFileChooser(factory, MessageService.getParentComponent());
        if (file == null) {
            return null;
        }
        factory.setSaveFile(file);
        return DownloaderUtils.createDownloader(factory, OSUtils.isAnyMac());
    }

    public static Downloader createDownloader(MagnetOptions magnet) {
        String msg = magnet.getErrorMessage();
        if (!magnet.isDownloadable()) {
            if (msg == null) {
                msg = magnet.toString();
            }
            GUIMediator.showError(I18n.tr("Could not process bad MAGNET link {0}", msg));
            return null;
        }
        if (msg != null) {
            GUIMediator.showWarning(I18n.tr("One or more URLs in the MAGNET link were invalid. Your file may not download correctly."));
        }
        MagnetDownloaderFactory factory = new MagnetDownloaderFactory(magnet);
        if (magnet.getDisplayName() == null) {
            Downloader dl = DownloaderUtils.createDownloaderAs(factory);
            if (dl != null && magnet.isHashOnly()) {
                GUIMediator.showError(I18n.tr("LimeWire may not be able to start the download you have selected unless you start a search for it."));
            }
            return dl;
        }
        return DownloaderUtils.createDownloader(factory);
    }

    public static Downloader createDownloader(GuiDownloaderFactory factory, boolean overwrite) {
        try {
            return factory.createDownloader(overwrite);
        }
        catch (SaveLocationException sle) {
            return DownloaderDialog.handle(factory, sle);
        }
    }

    public static boolean isAlreadyDownloading(GuiDownloaderFactory factory) {
        if (GuiCoreMediator.getDownloadManager().conflicts(factory.getURN(), (int)factory.getFileSize(), factory.getSaveFile())) {
            DownloaderUtils.showIsAlreadyDownloadingWarning(factory);
            return true;
        }
        return false;
    }

    public static void showIsAlreadyDownloadingWarning(GuiDownloaderFactory factory) {
        GUIMediator.showError(I18n.tr("You are already downloading this file to \"{0}\".", factory.getSaveFile()), QuestionsHandler.ALREADY_DOWNLOADING);
    }

    public static FileDesc getFromLibrary(URN urn) {
        if (urn == null) {
            return null;
        }
        FileDesc desc = GuiCoreMediator.getFileManager().getFileDescForUrn(urn);
        return desc instanceof IncompleteFileDesc ? null : desc;
    }

    public static boolean continueWithOrWithoutHashConflict(GuiDownloaderFactory factory) {
        FileDesc desc = DownloaderUtils.getFromLibrary(factory.getURN());
        if (desc != null) {
            return DownloaderUtils.showHashConflict(desc);
        }
        return true;
    }

    private static boolean showHashConflict(FileDesc desc) {
        String message = MessageFormat.format(I18n.tr("You already have the exact same file at {0}"), desc.getFile());
        String question = I18n.tr("Do you want to continue downloading anyway?");
        String continueLabel = I18n.tr("Continue");
        String[] content = new String[]{message, question};
        JOptionPane pane = new JOptionPane(content, 3, 0, null, new String[]{continueLabel, I18n.tr("Cancel")});
        JDialog dialog = pane.createDialog(MessageService.getParentComponent(), I18n.tr("Same File Already In Library"));
        dialog.setVisible(true);
        return continueLabel.equals(pane.getValue());
    }

    public static File showFileChooser(GuiDownloaderFactory factory, Component c) {
        return FileChooserHandler.getSaveAsFile(c, I18nMarker.marktr("Save Download As"), factory.getSaveFile());
    }

    private static boolean isSaveLocationTaken(GuiDownloaderFactory factory) {
        return factory.getSaveFile().exists() || GuiCoreMediator.getDownloadManager().isSaveLocationTaken(factory.getSaveFile());
    }
}

