/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.download.GuiDownloaderFactory;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;

public class StoreDownloaderFactory
implements GuiDownloaderFactory {
    private final RemoteFileDesc rfd;
    private File saveDir;
    private String fileName;

    public StoreDownloaderFactory(RemoteFileDesc rfd, String fileName) {
        this.rfd = rfd;
        this.fileName = fileName != null ? fileName : rfd.getFileName();
        this.saveDir = SharingSettings.getSaveLWSDirectory();
    }

    public File getSaveFile() {
        return new File(this.saveDir, this.fileName);
    }

    public void setSaveFile(File saveFile) {
        if (saveFile != null && !saveFile.isDirectory()) {
            this.fileName = saveFile.getName();
            this.saveDir = saveFile.getParentFile();
        }
    }

    public URN getURN() {
        return this.rfd.getSHA1Urn();
    }

    public long getFileSize() {
        return this.rfd.getSize();
    }

    public String download() {
        Downloader d = null;
        try {
            d = this.createDownloader(true);
        }
        catch (SaveLocationException saveLocationException) {
            // empty catch block
        }
        return String.valueOf(System.identityHashCode(d));
    }

    public Downloader createDownloader(boolean overwrite) throws SaveLocationException {
        return GuiCoreMediator.getDownloadServices().downloadFromStore(this.rfd, overwrite, this.saveDir, this.fileName);
    }
}

