/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.settings.iTunesSettings;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class iTunesMediator {
    private static final Log LOG = LogFactory.getLog(iTunesMediator.class);
    private static iTunesMediator INSTANCE;
    private final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("iTunesAdderThread");

    public static synchronized iTunesMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new iTunesMediator();
        }
        return INSTANCE;
    }

    private iTunesMediator() {
    }

    public void addSong(File file) {
        File[] files;
        if (!OSUtils.isMacOSX()) {
            return;
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (!file.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("File: '" + file + "' does not exist");
            }
            return;
        }
        if (file.isDirectory()) {
            files = FileUtils.getFilesRecursive(file, iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue());
        } else if (file.isFile() && iTunesMediator.isSupported(FileUtils.getFileExtension(file))) {
            files = new File[]{file};
        } else {
            return;
        }
        for (File toAdd : files) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Will add '" + toAdd + "' to Playlist");
            }
            this.QUEUE.execute(new ExecOSAScriptCommand(toAdd));
        }
    }

    private static boolean isSupported(String extension) {
        if (extension == null) {
            return false;
        }
        String[] types = iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue();
        for (int i = 0; i < types.length; ++i) {
            if (!extension.equalsIgnoreCase(types[i])) continue;
            return true;
        }
        return false;
    }

    private static String[] createOSAScriptCommand(File file) {
        String path = file.getAbsolutePath();
        String playlist = iTunesSettings.ITUNES_PLAYLIST.getValue();
        String[] command = new String[]{"osascript", "-e", "tell application \"Finder\"", "-e", "set hfsFile to (POSIX file \"" + path + "\")", "-e", "set thePlaylist to \"" + playlist + "\"", "-e", "tell application \"iTunes\"", "-e", "launch", "-e", "if not (exists playlist thePlaylist) then", "-e", "set thisPlaylist to make new playlist", "-e", "set name of thisPlaylist to thePlaylist", "-e", "end if", "-e", "add hfsFile to playlist thePlaylist", "-e", "end tell", "-e", "end tell"};
        return command;
    }

    private class ExecOSAScriptCommand
    implements Runnable {
        private final File file;

        public ExecOSAScriptCommand(File file) {
            this.file = file;
        }

        public void run() {
            try {
                Runtime.getRuntime().exec(iTunesMediator.createOSAScriptCommand(this.file));
            }
            catch (IOException err) {
                LOG.debug(err);
            }
        }
    }
}

