/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.WindowsUtils;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.ContentSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.MacOSXUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.OSUtils;

final class MiscWindow
extends SetupWindow {
    private ButtonGroup _speedGroup;
    private JRadioButton _modem;
    private JRadioButton _cable;
    private JCheckBox _startup;
    private JCheckBox _filter;

    MiscWindow(SetupManager manager) {
        super(manager, I18nMarker.marktr("Miscellaneous Settings"), I18nMarker.marktr("Below, are several options that affect the performance and functionality of LimeWire."));
    }

    protected void createWindow() {
        SetupWindow.MultiLineLabel desc;
        super.createWindow();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(new TitledBorder(I18n.tr("Network Speed")));
        this._speedGroup = new ButtonGroup();
        this._modem = new JRadioButton(I18n.tr("Dial Up"));
        this._cable = new JRadioButton(I18n.tr("Broadband (or unsure)"));
        this._speedGroup.add(this._modem);
        this._speedGroup.add(this._cable);
        SetupWindow.MultiLineLabel speedDesc = new SetupWindow.MultiLineLabel(I18n.tr("Please choose the speed of your internet connection. Setting this speed correctly is important for optimum network performance."));
        speedDesc.setOpaque(false);
        speedDesc.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
        speedDesc.setForeground(Color.black);
        speedDesc.setFont(speedDesc.getFont().deriveFont(0));
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        buttonPanel.add((Component)speedDesc, gbc);
        gbc.weightx = 0.0;
        gbc.gridwidth = -1;
        buttonPanel.add((Component)this._cable, gbc);
        gbc.insets = new Insets(0, 20, 0, 0);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        buttonPanel.add((Component)this._modem, gbc);
        gbc.insets = new Insets(0, 0, 10, 0);
        mainPanel.add((Component)buttonPanel, gbc);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            gbc = new GridBagConstraints();
            JPanel startupPanel = new JPanel(new GridBagLayout());
            startupPanel.setBorder(new TitledBorder(I18n.tr("System Startup")));
            this._startup = new JCheckBox(I18n.tr("Start Automatically"));
            this._startup.setSelected(StartupSettings.RUN_ON_STARTUP.getValue());
            desc = new SetupWindow.MultiLineLabel(I18n.tr("Would you like LimeWire to start when you log into your computer? This will cause LimeWire to start faster when you use it later."));
            desc.setOpaque(false);
            desc.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
            desc.setForeground(Color.black);
            desc.setFont(desc.getFont().deriveFont(0));
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            startupPanel.add((Component)desc, gbc);
            startupPanel.add((Component)this._startup, gbc);
            gbc.insets = new Insets(0, 0, 10, 0);
            mainPanel.add((Component)startupPanel, gbc);
        }
        gbc = new GridBagConstraints();
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.setBorder(new TitledBorder(I18n.tr("Content Filtering")));
        this._filter = new JCheckBox(I18n.tr("Enable Content Filtering"));
        this._filter.setSelected(ContentSettings.USER_WANTS_MANAGEMENTS.getValue());
        desc = new SetupWindow.MultiLineLabel(I18n.tr("LimeWire can filter files that copyright owners request not be shared. By enabling filtering, you are telling LimeWire to confirm all files you download or share with a list of removed content. You can change this at any time by choosing Filters -> Configure Content Filters from the main menu."));
        desc.setOpaque(false);
        desc.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
        desc.setForeground(Color.black);
        desc.setFont(desc.getFont().deriveFont(0));
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        URLLabel url = new URLLabel(ContentSettings.LEARN_MORE_URL, I18n.tr("Learn more about this option..."));
        url.setOpaque(false);
        url.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        url.setForeground(Color.black);
        url.setOpaque(false);
        url.setAlignmentY(1.0f);
        filterPanel.add((Component)desc, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        filterPanel.add((Component)url, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        filterPanel.add((Component)this._filter, gbc);
        gbc.insets = new Insets(0, 0, 10, 0);
        mainPanel.add((Component)filterPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        mainPanel.add((Component)new JPanel(), gbc);
        this.setSetupComponent(mainPanel);
        int speed = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (56 == speed) {
            this._modem.setSelected(true);
        } else if (350 == speed) {
            this._cable.setSelected(true);
        } else {
            this._cable.setSelected(true);
        }
    }

    public void applySettings(boolean loadCoreComponents) {
        int speed = this.getSpeed();
        this.setDownloadSlots(speed);
        if (speed < 0 || 20000 < speed) {
            throw new IllegalArgumentException();
        }
        ConnectionSettings.CONNECTION_SPEED.setValue(speed);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            boolean allow = this._startup.isSelected();
            if (OSUtils.isMacOSX()) {
                MacOSXUtils.setLoginStatus(allow);
            } else if (WindowsUtils.isLoginStatusAvailable()) {
                WindowsUtils.setLoginStatus(allow);
            }
            StartupSettings.RUN_ON_STARTUP.setValue(allow);
        }
        ContentSettings.USER_WANTS_MANAGEMENTS.setValue(this._filter.isSelected());
    }

    private int getSpeed() {
        if (this._cable.isSelected()) {
            return 350;
        }
        return 56;
    }

    private void setDownloadSlots(int speed) {
        if (speed == 56) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(3);
        } else if (speed == 350) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(8);
        } else {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(3);
        }
    }
}

