/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.actions.RemoveSharedDirectoryAction;
import com.limegroup.gnutella.gui.actions.SelectSharedDirectoryAction;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.library.RecursiveSharingPanel;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.StringUtils;

class SaveWindow
extends SetupWindow {
    private static final String LEARN_MORE_URL = "http://www.limewire.org/wiki/index.php?title=Save_Folder_and_Shared_Folders";
    private final JTextField SAVE_FIELD = new JTextField(20);
    private String _defaultSaveDir;
    private final RecursiveSharingPanel recursiveSharingPanel = new RecursiveSharingPanel(new File[0]);

    SaveWindow(SetupManager manager, boolean migrate) {
        super(manager, I18nMarker.marktr("Save Folder and Shared Folders"), SaveWindow.describeText(migrate), LEARN_MORE_URL);
        this.recursiveSharingPanel.getTree().setRootVisible(false);
        this.recursiveSharingPanel.getTree().setShowsRootHandles(true);
        this.recursiveSharingPanel.setRoots(SharingSettings.DIRECTORIES_TO_SHARE.getValueAsArray());
        this.recursiveSharingPanel.addRoot(SharingSettings.DEFAULT_SHARE_DIR);
        this.recursiveSharingPanel.setFoldersToExclude(GuiCoreMediator.getFileManager().getFolderNotToShare());
        this.recursiveSharingPanel.setRootsExpanded();
    }

    private static String describeText(boolean migrate) {
        if (!migrate) {
            return I18nMarker.marktr("Please choose a folder where you would like your files to be downloaded. You can also choose folders you would like to share with other users running LimeWire.  Files you download will also be shared with other users running LimeWire.");
        }
        return I18nMarker.marktr("LimeWire now downloads files to a new, different folder.  Please confirm the folder where you would like your files to be downloaded. You can also choose folders you would like to share with other users running LimeWire.  Files you download will also be shared with other users running LimeWire.");
    }

    protected void createWindow() {
        super.createWindow();
        this.recursiveSharingPanel.updateLanguage();
        File saveDir = SharingSettings.getSaveDirectory();
        try {
            this._defaultSaveDir = saveDir.getCanonicalPath();
        }
        catch (IOException e) {
            this._defaultSaveDir = saveDir.getAbsolutePath();
        }
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 6, 0);
        gbc.gridwidth = 0;
        mainPanel.add((Component)new JLabel(I18n.tr("Save Folder")), gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 6, 0);
        gbc.gridwidth = 0;
        mainPanel.add((Component)this.SAVE_FIELD, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        mainPanel.add((Component)new ButtonRow(new Action[]{new DefaultAction(), new BrowseAction()}, 0, 12), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(12, 0, 6, 0);
        gbc.gridwidth = 0;
        mainPanel.add((Component)new JLabel(I18n.tr("Shared Folders")), gbc);
        JPanel sharingPanelContainer = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.gridheight = 0;
        gbc.gridwidth = -1;
        sharingPanelContainer.add((Component)this.recursiveSharingPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 6, 0, 0);
        sharingPanelContainer.add((Component)new JButton(new SelectSharedDirectoryAction(this.recursiveSharingPanel, this._manager.getOwnerComponent())), gbc);
        gbc.insets = new Insets(6, 6, 0, 0);
        sharingPanelContainer.add((Component)new JButton(new RemoveSharedDirectoryAction(this.recursiveSharingPanel)), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        mainPanel.add((Component)sharingPanelContainer, gbc);
        try {
            this.SAVE_FIELD.setText(this._defaultSaveDir);
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        this.setSetupComponent(mainPanel);
    }

    public void applySettings(boolean loadCoreComponents) throws ApplySettingsException {
        ArrayList<String> errors = new ArrayList<String>(2);
        try {
            String saveDirString = this.SAVE_FIELD.getText();
            File saveDir = new File(saveDirString);
            if (loadCoreComponents) {
                SaveDirectoryHandler.ValidationResult result = SaveDirectoryHandler.isFolderValidForSaveDirectory(saveDir);
                switch (result) {
                    case VALID: {
                        break;
                    }
                    case BAD_BANNED: 
                    case BAD_VISTA: 
                    case BAD_SENSITIVE: {
                        throw new ApplySettingsException();
                    }
                    default: {
                        GUIMediator.showError(I18n.tr("The save folder is invalid. You may not have permissions to write to the selected folder.  Please choose another save folder."));
                        throw new ApplySettingsException();
                    }
                }
                if (!saveDir.isDirectory() && !saveDir.mkdirs()) {
                    throw new IOException();
                }
            }
            SharingSettings.setSaveDirectory(saveDir);
        }
        catch (IOException ioe) {
            errors.add(I18n.tr("LimeWire was unable to use the specified folder for saving files. Please try a different folder."));
        }
        File defaultShareDir = SharingSettings.DEFAULT_SHARE_DIR;
        Set<File> roots = this.recursiveSharingPanel.getRootsToShare();
        if (roots.contains(defaultShareDir)) {
            if (defaultShareDir.isFile()) {
                errors.add(I18n.tr("LimeWire could not create default share folder {0}, a file with that name already exists.", defaultShareDir));
            } else if (!defaultShareDir.isDirectory() && !defaultShareDir.mkdirs()) {
                errors.add(I18n.tr("LimeWire could not create default share folder {0}, it will not be shared.", defaultShareDir));
            }
        }
        if (loadCoreComponents) {
            GuiCoreMediator.getFileManager().loadWithNewDirectories(roots, this.recursiveSharingPanel.getFoldersToExclude());
        }
        if (!errors.isEmpty()) {
            throw new ApplySettingsException(StringUtils.explode(errors, "\n\n"));
        }
    }

    private class BrowseAction
    extends AbstractAction {
        public BrowseAction() {
            this.putValue("Name", I18n.tr("Browse..."));
            this.putValue("ShortDescription", I18n.tr("Choose Another Folder"));
        }

        public void actionPerformed(ActionEvent e) {
            File saveDir = FileChooserHandler.getInputDirectory(SaveWindow.this);
            if (saveDir == null || !saveDir.isDirectory()) {
                return;
            }
            SaveWindow.this.SAVE_FIELD.setText(saveDir.getAbsolutePath());
        }
    }

    private class DefaultAction
    extends AbstractAction {
        public DefaultAction() {
            this.putValue("Name", I18n.tr("Use Default"));
            this.putValue("ShortDescription", I18n.tr("Use the Default Folder"));
        }

        public void actionPerformed(ActionEvent e) {
            SaveWindow.this.SAVE_FIELD.setText(SaveWindow.this._defaultSaveDir);
        }
    }
}

