/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

abstract class SetupWindow
extends JPanel {
    public static final int SETUP_WIDTH = 700;
    public static final int SETUP_HEIGHT = 540;
    private String _key;
    private String _labelKey;
    private String _moreInfoURL;
    private SetupWindow _next;
    private SetupWindow _previous;
    protected final SetupManager _manager;

    SetupWindow(SetupManager manager, String key, String labelKey) {
        this(manager, key, labelKey, null);
    }

    SetupWindow(SetupManager manager, String key, String labelKey, String moreInfoURL) {
        this._manager = manager;
        this._key = key;
        this._labelKey = labelKey;
        this._moreInfoURL = moreInfoURL;
    }

    protected void createWindow() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel jpTop = new JPanel();
        jpTop.setLayout(new BorderLayout());
        jpTop.setBackground(Color.white);
        jpTop.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)jpTop, "North");
        JPanel jpTitle = new JPanel(new BorderLayout());
        jpTitle.setOpaque(false);
        jpTop.add((Component)jpTitle, "Center");
        JLabel jlTitle = new JLabel(I18n.tr(this._key));
        jlTitle.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 5));
        jlTitle.setFont(new Font("Dialog", 1, 16));
        jlTitle.setForeground(Color.black);
        jlTitle.setOpaque(false);
        jpTitle.add((Component)jlTitle, "North");
        MultiLineLabel jtaDescription = new MultiLineLabel(I18n.tr(this._labelKey));
        jtaDescription.setOpaque(false);
        jtaDescription.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        jtaDescription.setForeground(Color.black);
        jtaDescription.setFont(jtaDescription.getFont().deriveFont(0));
        jpTitle.add((Component)jtaDescription, "Center");
        if (this._moreInfoURL != null) {
            URLLabel jlURL = new URLLabel(this._moreInfoURL, I18n.tr("Learn more about this option..."));
            jlURL.setOpaque(false);
            jlURL.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
            jlURL.setForeground(Color.black);
            jlURL.setOpaque(false);
            jpTitle.add((Component)jlURL, "South");
        }
        JLabel jlIcon = new JLabel();
        jlIcon.setOpaque(false);
        jlIcon.setIcon(this.getIcon());
        jlIcon.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 8));
        jpTop.add((Component)jlIcon, "East");
    }

    public String getName() {
        if (this._key == null) {
            return null;
        }
        return I18n.tr(this._key);
    }

    public String getKey() {
        return this._key;
    }

    protected void setLabelKey(String newKey) {
        this._labelKey = newKey;
    }

    public Icon getIcon() {
        return null;
    }

    public SetupWindow getNext() {
        return this._next;
    }

    public SetupWindow getPrevious() {
        return this._previous;
    }

    public void setNext(SetupWindow next) {
        this._next = next;
    }

    public void setPrevious(SetupWindow previous) {
        this._previous = previous;
    }

    public void handleWindowOpeningEvent() {
        this.createWindow();
        this._manager.enableActions(this.getAppropriateActions());
    }

    protected int getAppropriateActions() {
        int actions = 8;
        if (this._next == this) {
            actions |= 4;
        } else if (this._next != null) {
            actions |= 2;
        }
        if (this._previous != this) {
            actions |= 1;
        }
        return actions;
    }

    public void applySettings(boolean loadCoreComponents) throws ApplySettingsException {
    }

    protected void setSetupComponent(JComponent setupComponent) {
        setupComponent.setBorder(new EmptyBorder(20, 10, 10, 10));
        this.add((Component)setupComponent, "Center");
        this.revalidate();
    }

    protected static class MultiLineLabel
    extends JTextArea {
        public MultiLineLabel(String s) {
            this.setEditable(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setHighlighter(null);
            LookAndFeel.installBorder(this, "Label.border");
            LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
            this.setSelectedTextColor(UIManager.getColor("Label.foreground"));
            this.setText(s);
        }

        public MultiLineLabel() {
            this(" ");
        }
    }
}

