/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.library.DirectoryHolder;
import com.limegroup.gnutella.gui.library.IncompleteDirectoryHolder;
import com.limegroup.gnutella.gui.library.LWSSpecialFilesHolder;
import com.limegroup.gnutella.gui.library.LibrarySearchPanel;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.library.RecursiveSharingDialog;
import com.limegroup.gnutella.gui.library.SavedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.sharing.ShareManager;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.gui.util.DividerLocationSettingUpdater;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LibraryMediator
implements ThemeObserver {
    private static final JPanel MAIN_PANEL = new JPanel(new GridBagLayout());
    private static final CardLayout viewLayout = new CardLayout();
    private static final JPanel viewPanel = new JPanel(viewLayout);
    private static final LibraryTree LIBRARY_TREE = LibraryTree.instance();
    private static final JScrollPane TREE_SCROLL_PANE;
    private static final LibraryTableMediator LIBRARY_TABLE;
    private static final String TABLE_KEY = "LIBRARY_TABLE";
    private static final String SHARED_KEY = "SHARED";
    private static final String STORE_KEY = "STORE";
    private final HandleFileUpdate FILE_UPDATER = new HandleFileUpdate();
    private static JPanel jpShared;
    private static JPanel storeShared;
    private static final LibraryMediator INSTANCE;

    public static LibraryMediator instance() {
        return INSTANCE;
    }

    private LibraryMediator() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Library Window..."));
        ThemeMediator.addThemeObserver(this);
        LibraryMediator.addView(LIBRARY_TABLE.getScrolledTablePane(), TABLE_KEY);
        JSplitPane splitPane = new JSplitPane(1, TREE_SCROLL_PANE, viewPanel);
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        DividerLocationSettingUpdater.install(splitPane, UISettings.UI_LIBRARY_TREE_DIVIDER_LOCATION);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add(LIBRARY_TREE.getButtonRow(), "West");
        buttonPanel.add((Component)LIBRARY_TABLE.getButtonRow(), "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(6, 6, 6, 6);
        MAIN_PANEL.add((Component)new LibrarySearchPanel(GuiCoreMediator.getQueryRequestFactory()), gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 6, 6, 6);
        MAIN_PANEL.add((Component)splitPane, gbc);
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 6, 6, 6);
        MAIN_PANEL.add((Component)buttonPanel, gbc);
        this.updateTheme();
        LIBRARY_TREE.setInitialSelection();
    }

    @Override
    public void updateTheme() {
        LIBRARY_TREE.updateTheme();
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        TREE_SCROLL_PANE.getViewport().setBackground(tableColor);
    }

    public JComponent getComponent() {
        return MAIN_PANEL;
    }

    public void launchLibraryFile() {
        LIBRARY_TABLE.launch();
    }

    public void deleteLibraryFile() {
        LIBRARY_TABLE.removeSelection();
    }

    public void clearLibrary() {
        LIBRARY_TABLE.clearTable();
        LIBRARY_TREE.clear();
        this.quickRefresh();
    }

    public File getVisibleDirectory() {
        return LIBRARY_TREE.getSelectedDirectory();
    }

    public void quickRefresh() {
        DirectoryHolder dh = LIBRARY_TREE.getSelectedDirectoryHolder();
        if (dh instanceof SavedFilesDirectoryHolder || dh instanceof IncompleteDirectoryHolder || dh instanceof LWSSpecialFilesHolder) {
            LibraryMediator.updateTableFiles(dh);
        }
    }

    public void forceRefresh() {
        LibraryMediator.updateTableFiles(LIBRARY_TREE.getSelectedDirectoryHolder());
    }

    public void handleFileManagerEvent(FileManagerEvent evt) {
        LIBRARY_TREE.handleFileManagerEvent(evt);
        LIBRARY_TABLE.handleFileManagerEvent(evt, LIBRARY_TREE.getSelectedDirectoryHolder());
    }

    public void addSharedLibraryFolder() {
        File dir = FileChooserHandler.getInputDirectory();
        if (dir == null) {
            return;
        }
        this.addSharedLibraryFolder(dir);
    }

    public void addSharedLibraryFolder(File dir) {
        RecursiveSharingDialog dialog;
        if (ShareManager.checkAndWarnNewSharedFolder(dir) && (dialog = new RecursiveSharingDialog((Frame)GUIMediator.getAppFrame(), dir)).showChooseDialog(MessageService.getParentComponent()) == RecursiveSharingDialog.State.OK) {
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    GuiCoreMediator.getFileManager().addSharedFolders(dialog.getRootsToShare(), dialog.getFoldersToExclude());
                }
            });
        }
    }

    public void updateSharedFile(File file) {
        DirectoryHolder dh = LIBRARY_TREE.getSelectedDirectoryHolder();
        if (LIBRARY_TABLE.getTable().isShowing() && dh != null && dh.accept(file)) {
            this.FILE_UPDATER.addFileUpdate(file);
        }
    }

    public void setAnnotateEnabled(boolean enabled) {
        LIBRARY_TABLE.setAnnotateEnabled(enabled);
    }

    public void unshareLibraryFolder() {
        LIBRARY_TREE.unshareLibraryFolder();
    }

    void addFileToPlayList(File toAdd) {
        GUIMediator.getPlayList().addFileToPlaylist(toAdd);
    }

    void addFilesToPlayList(List<File> toAdd) {
        GUIMediator.getPlayList().addFilesToPlaylist(toAdd.toArray(new File[toAdd.size()]));
    }

    static void updateTableFiles(DirectoryHolder dirHolder) {
        LIBRARY_TABLE.updateTableFiles(dirHolder);
        LibraryMediator.showView(TABLE_KEY);
    }

    public static boolean incompleteDirectoryIsSelected() {
        return LIBRARY_TREE.incompleteDirectoryIsSelected();
    }

    static boolean isRenameEnabled() {
        return !LIBRARY_TREE.searchResultDirectoryIsSelected() && !LIBRARY_TREE.incompleteDirectoryIsSelected();
    }

    public static void showSharedFiles() {
        if (jpShared == null) {
            jpShared = new JPanel(new BorderLayout());
            JPanel jpInternal = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 0, 6, 0);
            jpInternal.add((Component)new JLabel(I18n.tr("You can configure the folders you share in LimeWire's Options.")), gbc);
            gbc.gridy = 1;
            jpInternal.add((Component)new JButton(new ConfigureOptionsAction("OPTIONS_SHARED_MAIN_TITLE", I18n.tr("Configure..."), I18n.tr("You can configure the folders you share in LimeWire's Options."))), gbc);
            jpShared.add((Component)jpInternal, "Center");
            jpShared.setBorder(BorderFactory.createEtchedBorder());
            LibraryMediator.addView(jpShared, SHARED_KEY);
        }
        LibraryMediator.showView(SHARED_KEY);
    }

    public static void showStoreFiles() {
        if (storeShared == null) {
            storeShared = new JPanel(new BorderLayout());
            storeShared.add(new JLabel(I18n.tr("Songs purchased from the LimeWire Store"), GUIMediator.getThemeImage("lws"), 0));
            storeShared.setBorder(BorderFactory.createEtchedBorder());
            LibraryMediator.addView(storeShared, STORE_KEY);
        }
        LibraryMediator.showView(STORE_KEY);
    }

    public static void showView(String key) {
        viewLayout.show(viewPanel, key);
    }

    public static void addView(Component c, String key) {
        viewPanel.add(c, key);
    }

    public static boolean setSelectedDirectory(File dir) {
        return LIBRARY_TREE.setSelectedDirectory(dir);
    }

    public static boolean setSelectedFile(File file) {
        boolean selected = LIBRARY_TREE.setSelectedDirectory(file.getParentFile());
        if (selected) {
            return LIBRARY_TABLE.setFileSelected(file);
        }
        return false;
    }

    public void setPlayerEnabled(boolean value) {
        LIBRARY_TABLE.setPlayerEnabled(value);
        LIBRARY_TREE.setPlayerEnabled(value);
    }

    static {
        LIBRARY_TREE.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        TREE_SCROLL_PANE = new JScrollPane(LIBRARY_TREE);
        LIBRARY_TABLE = LibraryTableMediator.instance();
        jpShared = null;
        storeShared = null;
        INSTANCE = new LibraryMediator();
    }

    private static final class HandleFileUpdate
    implements Runnable {
        private Vector<File> list = new Vector();
        private boolean active = false;

        public void addFileUpdate(File f) {
            this.list.addElement(f);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.list.size() > 0) {
                    File f = this.list.firstElement();
                    this.list.removeElementAt(0);
                    LIBRARY_TABLE.update(f);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            finally {
                this.active = false;
            }
        }
    }
}

