/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.search.SearchField;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.Document;

public class LibrarySearchPanel
extends JPanel {
    private AutoCompleteSearchField queryField = new AutoCompleteSearchField(40);
    private final QueryRequestFactory queryRequestFactory;

    LibrarySearchPanel(QueryRequestFactory queryRequestFactory) {
        super(new GridBagLayout());
        this.queryRequestFactory = queryRequestFactory;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 2, 0, 2);
        gbc.anchor = 17;
        JLabel label = new JLabel(I18n.tr("Search In Shared Files:") + " ");
        label.setLabelFor(this.queryField);
        label.setDisplayedMnemonic('S');
        this.add((Component)label, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.queryField, gbc);
        SearchLibraryAction a = new SearchLibraryAction();
        GUIUtils.bindKeyToAction(this.queryField, KeyStroke.getKeyStroke(10, 0), a);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)new JButton(a), gbc);
    }

    private class AutoCompleteSearchField
    extends AutoCompleteTextField {
        public AutoCompleteSearchField(int columns) {
            super(columns);
        }

        protected Document createDefaultModel() {
            return new SearchField.SearchFieldDocument();
        }
    }

    private class SearchLibraryAction
    extends AbstractAction {
        public SearchLibraryAction() {
            this.putValue("Name", I18n.tr("Search"));
        }

        public boolean validate(SearchInformation info) {
            switch (SearchMediator.validateInfo(info)) {
                case 1: {
                    return false;
                }
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            String query = LibrarySearchPanel.this.queryField.getText().trim();
            if (query.length() == 0) {
                LibrarySearchPanel.this.queryField.getToolkit().beep();
                return;
            }
            final SearchInformation info = SearchInformation.createKeywordSearch(query, null, MediaType.getAnyTypeMediaType());
            if (!this.validate(info)) {
                return;
            }
            LibrarySearchPanel.this.queryField.addToDictionary();
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    QueryRequest request = LibrarySearchPanel.this.queryRequestFactory.createQuery(info.getQuery());
                    FileManager fm = GuiCoreMediator.getFileManager();
                    Response[] resps = fm.query(request);
                    ArrayList<File> files = new ArrayList<File>(resps.length);
                    for (Response response : resps) {
                        FileDesc f = fm.get((int)response.getIndex());
                        if (f == null) continue;
                        files.add(f.getFile());
                    }
                    final File[] filesArray = files.toArray(new File[files.size()]);
                    Runnable r = new Runnable(){

                        public void run() {
                            LibraryTree.instance().getSearchResultsHolder().setResults(filesArray);
                            LibraryTree.instance().setSearchResultsNodeSelected();
                        }
                    };
                    GUIMediator.safeInvokeLater(r);
                }
            });
        }
    }
}

