/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.dnd.CompositeTransferable;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.library.DirectoryHolder;
import com.limegroup.gnutella.gui.library.IncompleteDirectoryHolder;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.library.LibraryTreeTransferable;
import com.limegroup.gnutella.gui.library.SavedFilesDirectoryHolder;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

class LibraryTreeTransferHandler
extends LimeTransferHandler {
    LibraryTreeTransferHandler() {
        super(1);
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors, DropInfo info) {
        return this.canImport(comp, transferFlavors);
    }

    public boolean importData(JComponent comp, Transferable t, DropInfo info) {
        return this.importData(comp, t);
    }

    protected Transferable createTransferable(JComponent comp) {
        LibraryTree tree = (LibraryTree)comp;
        DirectoryHolder holder = tree.getSelectedDirectoryHolder();
        List<File> files = FileTransferable.EMPTY_FILE_LIST;
        if (holder == null) {
            return null;
        }
        if (holder instanceof SavedFilesDirectoryHolder || holder instanceof IncompleteDirectoryHolder) {
            files = Arrays.asList(holder.getFiles());
        } else {
            File directory = holder.getDirectory();
            if (directory != null) {
                files = Collections.singletonList(directory);
            }
        }
        if (files.isEmpty()) {
            return new LibraryTreeTransferable(holder);
        }
        return new CompositeTransferable(new LibraryTreeTransferable(holder), new FileTransferable(files));
    }
}

