/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.library.RecursiveSharingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveSharingDialog
extends JDialog {
    private static final long serialVersionUID = 5104889057583433880L;
    private State state = State.CANCELLED;
    private RecursiveSharingPanel sharingPanel;
    private MultiLineLabel titleLabel;

    public RecursiveSharingDialog(Frame owner, File ... roots) {
        super(owner);
        this.initialize(roots);
    }

    public RecursiveSharingDialog(Dialog owner, File ... roots) {
        super(owner);
        this.initialize(roots);
    }

    private void initialize(File ... roots) {
        this.sharingPanel = new RecursiveSharingPanel(roots);
        this.sharingPanel.setRootsExpanded();
        JTree tree = this.sharingPanel.getTree();
        tree.setRootVisible(false);
        this.setTitle(I18n.tr("Folders to share"));
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new BorderLayout());
        content.setBorder(new EmptyBorder(6, 6, OSUtils.isMacOSX() ? 12 : 6, 6));
        this.titleLabel = new MultiLineLabel(I18n.tr("The following folders and subfolders will be shared.  You can uncheck any folders you do not want to share.  (You can change your shared folders at any time in LimeWire's options.)"), 400, true);
        this.titleLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
        content.add((Component)this.titleLabel, "North");
        content.add((Component)this.sharingPanel, "Center");
        ButtonRow buttonRow = new ButtonRow(new Action[]{new OkayAction(), new CancelAction()}, 0, 12);
        buttonRow.setBorder(new EmptyBorder(6, 0, 0, 0));
        content.add((Component)buttonRow, "South");
        GUIUtils.addHideAction(this);
        this.pack();
    }

    public void setTitleText(String text) {
        this.titleLabel.setText(text, 400);
    }

    public State showChooseDialog(Component c) {
        return this.showChooseDialog(c, true);
    }

    public State showChooseDialog(Component c, boolean dontShowDialogIfNoSubfolders) {
        Set<File> roots = this.getRootsToShare();
        if (dontShowDialogIfNoSubfolders && roots.size() == this.sharingPanel.getTree().getRowCount()) {
            return State.OK;
        }
        this.setModal(true);
        this.setLocationRelativeTo(c);
        this.setVisible(true);
        roots = this.getRootsToShare();
        if (roots.isEmpty()) {
            this.state = State.CANCELLED;
        }
        return this.state;
    }

    public Set<File> getRootsToShare() {
        return this.sharingPanel.getRootsToShare();
    }

    public Set<File> getFoldersToExclude() {
        return this.sharingPanel.getFoldersToExclude();
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(I18n.tr("Cancel"));
        }

        public void actionPerformed(ActionEvent e) {
            RecursiveSharingDialog.this.state = State.CANCELLED;
            RecursiveSharingDialog.this.dispose();
        }
    }

    private class OkayAction
    extends AbstractAction {
        public OkayAction() {
            super(I18n.tr("OK"));
        }

        public void actionPerformed(ActionEvent e) {
            RecursiveSharingDialog.this.state = State.OK;
            RecursiveSharingDialog.this.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        OK,
        CANCELLED;

    }
}

