/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.logging;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.logging.LogType;
import com.limegroup.gnutella.uploader.UploadType;
import java.io.File;

public class LogEvent {
    private final long time = System.currentTimeMillis();
    private final LogType type;
    private final String message;

    public LogEvent(Downloader d) {
        this.type = LogType.DOWNLOAD;
        File f = d.getSaveFile();
        this.message = d.getAmountRead() == d.getContentLength() ? "<html>Download Finished - <b>" + (f == null ? "Unknown" : f.getName()) + "</b> <i>(" + GUIUtils.toUnitbytes(d.getContentLength()) + ")</i></html>" : "<html>Download Cancelled - <b>" + (f == null ? "Unknown" : f.getName()) + "</b> <i>(" + GUIUtils.toUnitbytes(d.getAmountRead()) + " of " + GUIUtils.toUnitbytes(d.getContentLength()) + ")</i></html>";
    }

    public LogEvent(Uploader u) {
        if (!u.getUploadType().isInternal()) {
            this.type = LogType.UPLOAD;
            this.message = "<html>Upload Started - <b>" + u.getFileName() + "</b> <i>(" + GUIUtils.toUnitbytes(u.getFileSize()) + ")</i></html>";
        } else if (u.getUploadType() == UploadType.BROWSE_HOST) {
            this.type = LogType.BROWSE_HOST;
            this.message = "<html>Host browsed by <b>" + u.getHost() + "</b></html>";
        } else {
            this.type = LogType.UPLOAD;
            this.message = "<html>Internal Upload</html>";
        }
    }

    long getTime() {
        return this.time;
    }

    LogType getType() {
        return this.type;
    }

    String getMessage() {
        return this.message;
    }
}

