/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.menu.FileMenu;
import com.limegroup.gnutella.gui.menu.FiltersMenu;
import com.limegroup.gnutella.gui.menu.HelpMenu;
import com.limegroup.gnutella.gui.menu.Menu;
import com.limegroup.gnutella.gui.menu.NavMenu;
import com.limegroup.gnutella.gui.menu.ResourcesMenu;
import com.limegroup.gnutella.gui.menu.ToolsMenu;
import com.limegroup.gnutella.gui.menu.ViewMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;

public final class MenuMediator {
    private static final MenuMediator INSTANCE;
    private final JMenuBar MENU_BAR = new JMenuBar();
    private final FileMenu FILE_MENU = new FileMenu();
    private final NavMenu NAV_MENU = new NavMenu();
    private final Menu RESOURCES_MENU = new ResourcesMenu();
    private final Menu TOOLS_MENU = new ToolsMenu();
    private final Menu FILTERS_MENU = new FiltersMenu();
    private final Menu HELP_MENU = new HelpMenu();
    private final Menu VIEW_MENU = new ViewMenu("VIEW");

    public static final MenuMediator instance() {
        return INSTANCE;
    }

    private MenuMediator() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Menus..."));
        this.MENU_BAR.setFont(AbstractMenu.FONT);
        this.addMenu(this.FILE_MENU);
        this.addMenu(this.VIEW_MENU);
        this.addMenu(this.NAV_MENU);
        this.addMenu(this.RESOURCES_MENU);
        this.addMenu(this.TOOLS_MENU);
        this.addMenu(this.FILTERS_MENU);
        this.addMenu(this.HELP_MENU);
    }

    public JMenuBar getMenuBar() {
        return this.MENU_BAR;
    }

    private void addMenu(Menu menu) {
        this.MENU_BAR.add(menu.getMenu());
    }

    public int getMenuBarHeight() {
        return this.MENU_BAR.getHeight();
    }

    static {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        INSTANCE = new MenuMediator();
    }
}

