/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.mp3.PlayListItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayList {
    private static final Log LOG = LogFactory.getLog(PlayList.class);
    private File playListFile;
    private Vector<PlayListItem> songs;
    private boolean isDirty;
    private static final String M3U_HEADER = "#EXTM3U";
    private static final String SONG_DELIM = "#EXTINF";
    private static final String SEC_DELIM = ":";

    public PlayList(String filename) {
        LOG.trace("PlayList(): entered.");
        this.playListFile = new File(filename);
        if (this.playListFile.isDirectory()) {
            throw new IllegalArgumentException(filename + " is a directory");
        }
        this.songs = new Vector();
        if (this.playListFile.exists()) {
            try {
                this.loadM3UFile();
            }
            catch (IOException ignored) {
                LOG.warn("Unable to load file: " + filename, ignored);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("songs = " + this.songs);
            LOG.trace("returning.  size is now " + this.getNumSongs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadM3UFile() throws IOException {
        BufferedReader m3uFile = null;
        try {
            m3uFile = new BufferedReader(new FileReader(this.playListFile));
            String currLine = null;
            currLine = m3uFile.readLine();
            if (currLine == null) throw new IOException();
            if (!currLine.startsWith(M3U_HEADER) && !currLine.startsWith(SONG_DELIM)) {
                throw new IOException();
            }
            if (currLine.startsWith(M3U_HEADER)) {
                currLine = m3uFile.readLine();
            }
            while (currLine != null) {
                if (currLine.startsWith(SONG_DELIM)) {
                    currLine = m3uFile.readLine();
                    if (currLine == null) break;
                    File toAdd = new File(currLine);
                    if (toAdd.exists() && !toAdd.isDirectory()) {
                        this.songs.add(new PlayListItem(toAdd));
                    } else {
                        toAdd = new File(this.playListFile.getParentFile().getAbsolutePath(), toAdd.getPath());
                        if (toAdd.exists() && !toAdd.isDirectory() && FileUtils.isReallyInParentPath(this.playListFile.getParentFile(), toAdd)) {
                            this.songs.add(new PlayListItem(toAdd));
                        }
                    }
                }
                currLine = m3uFile.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(m3uFile);
            throw throwable;
        }
        IOUtils.close(m3uFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws IOException {
        if (!this.isDirty) {
            return;
        }
        if (this.songs.size() == 0) {
            LOG.debug("No songs, deleting file");
            if (this.playListFile.exists()) {
                this.playListFile.delete();
            }
            return;
        }
        PrintWriter m3uFile = null;
        try {
            m3uFile = new PrintWriter(new FileWriter(this.playListFile.getCanonicalPath(), false));
            m3uFile.write(M3U_HEADER);
            m3uFile.println();
            for (PlayListItem currFile : this.songs) {
                if (!currFile.isFile()) continue;
                File locFile = new File(currFile.getURI());
                m3uFile.write(SONG_DELIM);
                m3uFile.write(SEC_DELIM);
                if (currFile.getProperty("Length") != null) {
                    m3uFile.write("" + currFile.getProperty("Length") + ",");
                } else {
                    m3uFile.write("-1,");
                }
                m3uFile.write(currFile.getName());
                m3uFile.println();
                m3uFile.write(locFile.getCanonicalPath());
                m3uFile.println();
            }
            this.isDirty = false;
        }
        catch (Throwable throwable) {
            this.isDirty = false;
            IOUtils.close(m3uFile);
            throw throwable;
        }
        IOUtils.close(m3uFile);
    }

    public int getNumSongs() {
        return this.songs.size();
    }

    public synchronized List<PlayListItem> getSongs() {
        return new LinkedList<PlayListItem>(this.songs);
    }

    public synchronized void setSongs(List<? extends PlayListItem> l) {
        this.isDirty = true;
        this.songs.clear();
        this.songs.addAll(l);
    }

    public PlayListItem getSong(int index) {
        return this.songs.get(index);
    }
}

