/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAudioInputStream
extends InputStream {
    private final RandomAccessFile file;
    private long fileBytePosition;

    public RandomAudioInputStream(RandomAccessFile file) {
        this.file = file;
        this.fileBytePosition = 0L;
    }

    public int read() throws IOException {
        int a = this.file.read();
        ++this.fileBytePosition;
        return a;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.file == null) {
            return -1;
        }
        int r = this.file.read(b, off, len);
        this.fileBytePosition += (long)r;
        return r;
    }

    public int available() throws IOException {
        return (int)(this.file.length() - this.fileBytePosition);
    }

    public long skip(long bytesToSkip) throws IOException {
        int bytes = this.file.skipBytes((int)bytesToSkip);
        this.fileBytePosition = bytes;
        return bytes;
    }

    public void close() throws IOException {
        this.file.close();
    }
}

