/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MediaSlider;
import com.limegroup.gnutella.gui.MediaSliderUI;
import com.limegroup.gnutella.gui.mp3.SongProgressBarUI;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.SliderUI;

public class SongProgressBar
extends MediaSlider {
    private String progressString;
    private boolean paintString = true;
    private final String PROGRESS;
    private BufferedImage progressImage;

    public SongProgressBar(String leftTrackName, String centerTrackName, String rightTrackName, String thumbName, String thumbPressedName, String progressName) {
        super(leftTrackName, centerTrackName, rightTrackName, thumbName, thumbPressedName);
        this.PROGRESS = progressName;
        if (!super.isFontSet()) {
            super.setFont(new Font("Default", 0, 9));
        }
        ThemeMediator.addThemeObserver(this);
        this.setMyImages();
        this.setUI(new SongProgressBarUI(this));
    }

    public void updateTheme() {
        this.setMyImages();
        ((MediaSliderUI)this.getUI()).setDirty(true);
    }

    public void setUI(SliderUI sliderUI) {
        if (sliderUI instanceof SongProgressBarUI) {
            super.setUI(sliderUI);
        }
    }

    protected void setMyImages() {
        super.setImages();
        this.setProgressImage(SongProgressBar.convertIconToImage(GUIMediator.getThemeImage(this.PROGRESS)));
    }

    public void setProgressImage(Image image) {
        this.progressImage = (BufferedImage)image;
    }

    public BufferedImage getProgressImage() {
        return this.progressImage;
    }

    public int getOrientation() {
        return 0;
    }

    public void setString(String name) {
        this.progressString = name;
        this.repaint();
    }

    public String getString() {
        return this.progressString;
    }

    public void setPaintString(boolean value) {
        if (this.paintString != value) {
            this.paintString = value;
            this.repaint();
        }
    }

    public boolean isStringPainted() {
        return this.paintString;
    }

    public void stateChanged(ChangeEvent e) {
        this.setToolTipText(Integer.toString(100 * this.getValue() / this.getMaximum()));
    }
}

