/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.MediaSliderUI;
import com.limegroup.gnutella.gui.mp3.SongProgressBar;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JSlider;

public class SongProgressBarUI
extends MediaSliderUI {
    protected BufferedImage progressImageCache;
    private boolean paintThumb = false;
    private ThumbMouse thumbMouseListener;

    public SongProgressBarUI(SongProgressBar b) {
        super(b);
    }

    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        this.thumbMouseListener = new ThumbMouse();
        slider.addMouseListener(this.thumbMouseListener);
    }

    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.thumbMouseListener);
    }

    public void paintTrack(Graphics g) {
        if (((SongProgressBar)this.slider).getProgressImage() == null) {
            super.paintTrack(g);
            return;
        }
        try {
            if (this.trackImageCache == null || this.progressImageCache == null) {
                this.createTrackCache();
                this.createProgressCache();
            } else if (this.isDirty) {
                if (this.slider.getOrientation() == 0) {
                    if (this.trackImageCache.getWidth() != this.contentRect.width) {
                        this.createTrackCache();
                    }
                    if (this.progressImageCache.getWidth() != this.contentRect.width / 4) {
                        this.createProgressCache();
                    }
                } else {
                    if (this.trackImageCache.getHeight() != this.contentRect.height) {
                        this.createTrackCache();
                    }
                    if (this.progressImageCache.getHeight() != this.contentRect.height / 4) {
                        this.createProgressCache();
                    }
                }
            }
            this.isDirty = false;
        }
        catch (IOException e) {
            super.paintTrack(g);
            return;
        }
        if (this.slider.getOrientation() == 0) {
            Rectangle trackBounds = this.contentRect;
            int cy = (trackBounds.height - this.trackImageCache.getHeight()) / 2;
            SongProgressBar songSlider = (SongProgressBar)this.slider;
            g.translate(trackBounds.x, trackBounds.y + cy);
            g.drawImage(this.trackImageCache, 0, 0, null);
            if (this.progressImageCache != null && this.slider.getValue() > this.slider.getMinimum()) {
                if (this.progressImageCache.getWidth() < trackBounds.width / 4) {
                    this.createProgressCache();
                }
                int value = this.trackRect.width * songSlider.getValue() / this.slider.getMaximum();
                g.drawImage(this.progressImageCache, this.trackRect.x, 0, value, this.progressImageCache.getHeight(), null);
            }
            if (songSlider.isStringPainted() && songSlider.getString().length() > 0) {
                FontMetrics metrics = g.getFontMetrics(this.slider.getFont());
                int fontHeight = metrics.getHeight();
                int x = this.trackRect.x + 6;
                int y = trackBounds.height / 2 + fontHeight / 3 - cy;
                Graphics2D g2 = (Graphics2D)g;
                g2.setFont(songSlider.getFont());
                g2.setColor(Color.BLACK);
                g2.drawString(songSlider.getString(), x, y);
            }
            g.translate(-trackBounds.x, -(trackBounds.y + cy));
        } else {
            super.paintTrack(g);
        }
    }

    public void createProgressCache() {
        if (this.slider.getOrientation() == 0) {
            SongProgressBar slide = (SongProgressBar)this.slider;
            BufferedImage i = new BufferedImage(this.contentRect.width / 4, slide.getProgressImage().getHeight(), 2);
            Graphics2D g = i.createGraphics();
            g.drawImage(slide.getProgressImage(), 0, 0, this.contentRect.width / 4, slide.getProgressImage().getHeight(), null);
            this.progressImageCache = i;
            g.dispose();
        } else {
            SongProgressBar slide = (SongProgressBar)this.slider;
            BufferedImage i = new BufferedImage(slide.getProgressImage().getWidth(), (int)(this.contentRect.getHeight() / 4.0), 2);
            Graphics2D g = i.createGraphics();
            g.drawImage(slide.getProgressImage(), 0, 0, slide.getProgressImage().getWidth(), (int)(this.contentRect.getHeight() / 4.0), null);
            this.progressImageCache = i;
            g.dispose();
        }
    }

    public void paintThumb(Graphics g) {
        if (!this.paintThumb || !this.slider.isEnabled()) {
            return;
        }
        super.paintThumb(g);
    }

    protected void mouseSkip(int x) {
        this.slider.setValue(this.valueForXPosition(x));
        this.slider.repaint();
    }

    private class ThumbMouse
    extends MouseAdapter {
        private ThumbMouse() {
        }

        public void mousePressed(MouseEvent e) {
            if (!SongProgressBarUI.this.slider.isEnabled()) {
                return;
            }
            SongProgressBarUI.this.mouseSkip(e.getX());
        }

        public void mouseEntered(MouseEvent arg0) {
            if (!SongProgressBarUI.this.slider.isEnabled()) {
                return;
            }
            SongProgressBarUI.this.paintThumb = true;
            SongProgressBarUI.this.slider.repaint();
        }

        public void mouseExited(MouseEvent arg0) {
            if (!SongProgressBarUI.this.slider.isEnabled()) {
                return;
            }
            SongProgressBarUI.this.paintThumb = false;
            SongProgressBarUI.this.slider.repaint();
        }
    }
}

