/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.notify.AnimatedWindowEvent;
import com.limegroup.gnutella.gui.notify.AnimatedWindowListener;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnimatedWindow
extends JWindow {
    private static final int ANIMATION_INTERVAL = 10;
    private static final int MOVE_PER_INTERVAL = 1;
    private static final float FADE_PER_INTERVAL = 0.015f;
    private static final Log LOG = LogFactory.getLog(AnimatedWindow.class);
    public static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private AnimationMode mode = AnimationMode.BOTTOM_TO_TOP;
    private Timer animationTimer;
    private BufferedImage animationImage;
    private boolean hideOnClick;
    private int initialHeight;
    private Point finalLocation;
    private float opacity;
    private BufferedImage backgroundImage;
    private List<AnimatedWindowListener> listeners;
    private AnimationType currentAnimation;
    private Container contentPane;

    public AnimatedWindow(Window parent) {
        super(parent);
    }

    public Color getContentBackground() {
        return this.getContentPane().getBackground();
    }

    protected void autoHideWindow() {
        this.doHide();
    }

    public void doHide() {
        if (this.currentAnimation == AnimationType.HIDE) {
            return;
        }
        this.stopAnimations(true);
        final Point location = this.getLocation();
        this.prepareAnimation(location);
        this.currentAnimation = AnimationType.HIDE;
        this.animationTimer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                boolean done = AnimatedWindow.this.mode.animateHide(AnimatedWindow.this, location);
                if (done) {
                    AnimatedWindow.this.currentAnimation = null;
                    AnimatedWindow.this.animationTimer.stop();
                    AnimatedWindow.this.disposeAnimation();
                    AnimatedWindow.this.setVisible(false);
                    AnimatedWindow.this.fireAnimationCompleted(AnimationType.HIDE);
                }
            }
        });
        this.animationTimer.setRepeats(true);
        this.animationTimer.start();
    }

    public void doShow() {
        if (this.currentAnimation == AnimationType.SHOW) {
            return;
        }
        this.stopAnimations(true);
        final Dimension preferredSize = this.getPreferredSize();
        final Point location = this.getFinalLocation();
        this.prepareAnimation(location);
        if (!this.isVisible()) {
            this.mode.initializeWindow(this, location);
            this.setVisible(true);
        }
        this.currentAnimation = AnimationType.SHOW;
        this.animationTimer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean done = AnimatedWindow.this.mode.animateShow(AnimatedWindow.this, location);
                if (done) {
                    if (location.y != AnimatedWindow.this.getLocation().y || (double)preferredSize.height != AnimatedWindow.this.getSize().getHeight()) {
                        AnimatedWindow.this.setBounds(location.x, location.y, preferredSize.width, preferredSize.height);
                    }
                    AnimatedWindow.this.animationImage = null;
                    AnimatedWindow.this.stopAnimations(false);
                    AnimatedWindow.this.validate();
                    AnimatedWindow.this.fireAnimationCompleted(AnimationType.SHOW);
                }
            }
        });
        this.animationTimer.setRepeats(true);
        this.animationTimer.start();
    }

    public int getInitialHeight() {
        return this.initialHeight;
    }

    public void setInitialHeight(int initialHeight) {
        this.initialHeight = initialHeight;
    }

    private void prepareAnimation(Point location) {
        if (this.animationImage != null) {
            return;
        }
        this.pack();
        Dimension size = this.getSize();
        if (this.mode.needsBackgroundImage() && this.backgroundImage == null) {
            try {
                Robot robot = new Robot();
                this.backgroundImage = robot.createScreenCapture(new Rectangle(location, size));
            }
            catch (AWTException e) {
                LOG.warn("Could not capture background image", e);
                this.backgroundImage = null;
            }
        }
        this.animationImage = this.getGraphicsConfiguration().createCompatibleImage(size.width, size.height);
        Graphics grahpics = this.animationImage.getGraphics();
        this.getContentPane().paint(grahpics);
        grahpics.dispose();
    }

    private void disposeAnimation() {
        this.animationImage = null;
        this.backgroundImage = null;
    }

    public Point getDefaultParentLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point(screenSize.width - 1, screenSize.height - 1);
    }

    public Dimension getDefaultParentSize() {
        return new Dimension(0, 0);
    }

    public void hideWindow() {
        this.doHide();
    }

    public void hideWindowImmediately() {
        this.stopAnimations(true);
        this.setVisible(false);
        this.disposeAnimation();
    }

    public Container getContentPane() {
        if (this.contentPane == null) {
            this.setContentPane(new JPanel());
        }
        return this.contentPane;
    }

    public void setContentPane(Container contentPane) {
        this.contentPane = contentPane;
        JPanel panel = new JPanel(new BorderLayout()){

            public void paint(Graphics g) {
                if (AnimatedWindow.this.animationImage != null && AnimatedWindow.this.isAnimationInProgress()) {
                    AnimatedWindow.this.mode.paint(AnimatedWindow.this, g, AnimatedWindow.this.backgroundImage, AnimatedWindow.this.animationImage);
                } else {
                    super.paint(g);
                }
            }
        };
        panel.setDoubleBuffered(true);
        panel.add((Component)contentPane, "Center");
        super.setContentPane(panel);
    }

    public boolean isAnimationInProgress() {
        return this.currentAnimation != null;
    }

    public boolean isHideAnimationInProgress() {
        return this.currentAnimation == AnimationType.HIDE;
    }

    public boolean isShowAnimationInProgress() {
        return this.currentAnimation == AnimationType.SHOW;
    }

    private void stopAnimations(boolean notify) {
        if (this.currentAnimation == null) {
            return;
        }
        this.currentAnimation = null;
        if (this.animationTimer != null) {
            this.animationTimer.stop();
        }
        if (notify) {
            this.fireAnimationStopped(this.currentAnimation);
        }
    }

    protected void fireAnimationStopped(AnimationType type) {
        if (this.listeners != null) {
            AnimatedWindowEvent event = new AnimatedWindowEvent(this, type);
            for (AnimatedWindowListener listener : this.listeners) {
                listener.animationStopped(event);
            }
        }
    }

    protected void fireAnimationCompleted(AnimationType type) {
        if (this.listeners != null) {
            AnimatedWindowEvent event = new AnimatedWindowEvent(this, type);
            for (AnimatedWindowListener listener : this.listeners) {
                listener.animationCompleted(event);
            }
        }
    }

    public boolean getHideOnClick() {
        return this.hideOnClick;
    }

    public void setHideOnClick(boolean hideOnClick) {
        this.hideOnClick = hideOnClick;
    }

    public AnimationMode getMode() {
        return this.mode;
    }

    public void setMode(AnimationMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
    }

    public static void main(String[] args) {
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        JLabel label = new JLabel("Hello World");
        label.setIcon(UIManager.getIcon("FileView.computerIcon"));
        label.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        content.add((Component)label, "Center");
        final AnimatedWindow window = new AnimatedWindow(null);
        window.setFinalLocation(new Point(200, 200));
        window.setContentPane(content);
        JPanel buttonPanel = new JPanel(new FlowLayout(3, 10, 10));
        JButton button = new JButton("Bottom -> Top");
        buttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                window.setMode(AnimationMode.BOTTOM_TO_TOP);
                if (!window.isVisible() || window.isHideAnimationInProgress()) {
                    window.doShow();
                } else {
                    window.doHide();
                }
            }
        });
        button = new JButton("Top -> Bottom");
        buttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                window.setMode(AnimationMode.TOP_TO_BOTTOM);
                if (!window.isVisible() || window.isHideAnimationInProgress()) {
                    window.doShow();
                } else {
                    window.doHide();
                }
            }
        });
        button = new JButton("Fade");
        buttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                window.setMode(AnimationMode.FADE);
                if (!window.isVisible() || window.isHideAnimationInProgress()) {
                    window.doShow();
                } else {
                    window.doHide();
                }
            }
        });
        JFrame app = new JFrame("AnimatedWindow Demo");
        app.setContentPane(buttonPanel);
        app.pack();
        app.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        app.setVisible(true);
    }

    public Point getFinalLocation() {
        return this.finalLocation;
    }

    public void setFinalLocation(Point finalLocation) {
        this.finalLocation = finalLocation;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.opacity = opacity;
    }

    public void addAnimatedWindowListener(AnimatedWindowListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<AnimatedWindowListener>();
        }
        this.listeners.add(listener);
    }

    public void removeAnimatedWindowListener(AnimatedWindowListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnimationMode {
        TOP_TO_BOTTOM,
        BOTTOM_TO_TOP,
        FADE;


        public boolean movesWindow() {
            switch (this) {
                case TOP_TO_BOTTOM: 
                case BOTTOM_TO_TOP: {
                    return true;
                }
                case FADE: {
                    return false;
                }
            }
            throw new RuntimeException("Unknown mode: " + (Object)((Object)this));
        }

        public boolean needsBackgroundImage() {
            switch (this) {
                case FADE: {
                    return true;
                }
            }
            return false;
        }

        public void initializeWindow(AnimatedWindow window, Point location) {
            Dimension preferredSize = window.getPreferredSize();
            switch (this) {
                case BOTTOM_TO_TOP: {
                    if (window.getContentBackground() != null) {
                        window.setBackground(window.getContentBackground());
                    }
                    window.setBounds(location.x, location.y + preferredSize.height - window.getInitialHeight(), preferredSize.width, window.getInitialHeight());
                    window.setOpacity(1.0f);
                    break;
                }
                case TOP_TO_BOTTOM: {
                    if (window.getContentBackground() != null) {
                        window.setBackground(window.getContentBackground());
                    }
                    window.setBounds(location.x, location.y, preferredSize.width, window.getInitialHeight());
                    window.setOpacity(1.0f);
                    break;
                }
                case FADE: {
                    window.setBounds(location.x, location.y, preferredSize.width, preferredSize.height);
                    window.setOpacity(0.0f);
                    window.setBackground(TRANSPARENT);
                }
            }
        }

        public boolean animateShow(AnimatedWindow window, Point location) {
            Dimension preferredSize = window.getPreferredSize();
            switch (this) {
                case BOTTOM_TO_TOP: {
                    if (window.getHeight() >= preferredSize.height) {
                        return true;
                    }
                    int newHeight = Math.min(window.getHeight() + 1, preferredSize.height);
                    window.setBounds(location.x, location.y + preferredSize.height - newHeight, preferredSize.width, newHeight);
                    window.validate();
                    return false;
                }
                case TOP_TO_BOTTOM: {
                    if (window.getHeight() >= preferredSize.height) {
                        return true;
                    }
                    window.setBounds(location.x, location.y, preferredSize.width, Math.min(window.getHeight() + 1, preferredSize.height));
                    window.validate();
                    return false;
                }
                case FADE: {
                    if (window.getOpacity() >= 1.0f) {
                        return true;
                    }
                    window.setOpacity(Math.min(window.getOpacity() + 0.015f, 1.0f));
                    window.repaint();
                    return false;
                }
            }
            return true;
        }

        public boolean animateHide(AnimatedWindow window, Point location) {
            Dimension preferredSize = window.getPreferredSize();
            switch (this) {
                case BOTTOM_TO_TOP: {
                    if (window.getHeight() == 0) {
                        return true;
                    }
                    int newHeight = Math.max(window.getHeight() - 1, 0);
                    try {
                        window.setBounds(location.x, location.y + preferredSize.height - newHeight, preferredSize.width, newHeight);
                    }
                    catch (IllegalArgumentException ignored) {
                        LOG.warn("IAE setting bounds", ignored);
                    }
                    window.validate();
                    return false;
                }
                case TOP_TO_BOTTOM: {
                    if (window.getHeight() == 0) {
                        return true;
                    }
                    window.setSize(preferredSize.width, Math.max(window.getHeight() - 1, 0));
                    window.validate();
                    return false;
                }
                case FADE: {
                    if (window.getOpacity() == 0.0f) {
                        return true;
                    }
                    window.setOpacity(Math.max(window.getOpacity() - 0.015f, 0.0f));
                    window.repaint();
                    return false;
                }
            }
            return true;
        }

        public void paint(AnimatedWindow window, Graphics g, BufferedImage backgroundImage, BufferedImage animationImage) {
            switch (this) {
                case BOTTOM_TO_TOP: {
                    g.drawImage(animationImage, 0, 0, null);
                    break;
                }
                case TOP_TO_BOTTOM: {
                    g.drawImage(animationImage, 0, window.getHeight() - window.getPreferredSize().height, null);
                    break;
                }
                case FADE: {
                    if (backgroundImage != null) {
                        g.drawImage(backgroundImage, 0, 0, null);
                    } else {
                        g.setColor(Color.white);
                        g.fillRect(0, 0, window.getWidth(), window.getHeight());
                    }
                    Graphics2D gFade = (Graphics2D)g.create();
                    AlphaComposite newComposite = AlphaComposite.getInstance(3, window.getOpacity());
                    gFade.setComposite(newComposite);
                    gFade.drawImage((Image)animationImage, 0, 0, null);
                    gFade.dispose();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnimationType {
        SHOW,
        HIDE;

    }
}

