/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.notify.DefaultNotificationRenderer;
import com.limegroup.gnutella.gui.notify.Notification;
import com.limegroup.gnutella.gui.notify.NotificationWindow;
import com.limegroup.gnutella.gui.notify.NotifyUser;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;

public class JDICNotifier
implements NotifyUser {
    private static final Log LOG = LogFactory.getLog(DefaultNotificationRenderer.class);
    private final SystemTray _tray = SystemTray.getDefaultSystemTray();
    private TrayIcon _icon;
    private NotificationWindow notificationWindow;

    public JDICNotifier() {
        this.buildPopupMenu();
        this.buildTrayIcon(I18n.tr("LimeWire"), "limeicon");
        this.buildNotificationWindow();
    }

    private void buildTrayIcon(String desc, String imageFileName) {
        this._icon = new TrayIcon(GUIMediator.getThemeImage(imageFileName), desc, GUIMediator.getTrayMenu());
        this._icon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.restoreView();
            }
        });
        this._icon.setIconAutoSize(true);
    }

    private JPopupMenu buildPopupMenu() {
        JPopupMenu menu = GUIMediator.getTrayMenu();
        JMenuItem item = new JMenuItem(I18n.tr("Restore"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.restoreView();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(I18n.tr("About"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.showAboutWindow();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(I18n.tr("Exit after Transfers"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.shutdownAfterTransfers();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n.tr("Exit"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.shutdown();
            }
        });
        menu.add(item);
        return menu;
    }

    private void buildNotificationWindow() {
        this.notificationWindow = new NotificationWindow((Window)GUIMediator.getAppFrame());
        this.notificationWindow.setLocationOffset(new Dimension(2, 7));
        this.notificationWindow.setTitle("LimeWire");
        this.notificationWindow.setIcon(GUIMediator.getThemeImage("limeicon.gif"));
    }

    public boolean showTrayIcon() {
        try {
            this._tray.addTrayIcon(this._icon);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        this.notificationWindow.setParentSize(new Dimension(22, 22));
        return true;
    }

    public boolean supportsSystemTray() {
        return true;
    }

    public void hideTrayIcon() {
        this._tray.removeTrayIcon(this._icon);
        this.notificationWindow.setParentLocation(null);
        this.notificationWindow.setParentSize(null);
    }

    public void showMessage(Notification notification) {
        try {
            this.notificationWindow.addNotification(notification);
            try {
                this.notificationWindow.setParentLocation(this._icon.getLocationOnScreen());
            }
            catch (NullPointerException ignore) {
                // empty catch block
            }
            this.notificationWindow.showWindow();
        }
        catch (Exception e) {
            LOG.error("Disabling notifications due to error", e);
            UISettings.SHOW_NOTIFICATIONS.setValue(false);
            this.notificationWindow.hideWindowImmediately();
        }
    }

    public void hideMessage(Notification notification) {
        this.notificationWindow.removeNotification(notification);
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.notificationWindow);
    }
}

