/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.notify.AnimatedWindow;
import com.limegroup.gnutella.gui.notify.AnimatedWindowEvent;
import com.limegroup.gnutella.gui.notify.AnimatedWindowListener;
import com.limegroup.gnutella.gui.notify.DefaultNotificationRenderer;
import com.limegroup.gnutella.gui.notify.NotificationRenderer;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public class NotificationWindow
extends AnimatedWindow {
    private static final int DEFAULT_TIMEOUT = 6000;
    private JLabel titleLabel;
    private Timer autoHideTimer;
    private String title;
    private JPanel mainPanel;
    private Icon titleIcon;
    private Point parentLocation;
    private Dimension parentSize;
    private BoxPanel topPanel;
    private ComboBoxModel model;
    private ModelListener modelListener = new ModelListener();
    private NotificationRenderer renderer = new DefaultNotificationRenderer();
    private Action previousNotificationAction = new PreviousNotificationAction();
    private Action nextNotificationAction = new NextNotificationAction();
    private Action closeAction = new CloseAction();
    private JLabel notificationIndexLabel;
    private Dimension locationOffset = new Dimension(0, 0);
    private boolean pendingScreenUpdate;

    public NotificationWindow(Window parent, ComboBoxModel model) {
        super(parent);
        this.setModel(model);
        this.initialize();
        this.autoHideTimer = new Timer(6000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NotificationWindow.this.showNextNotificationOrHideWindow();
            }
        });
        this.autoHideTimer.setRepeats(true);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                NotificationWindow.this.stopAutoHideTimer();
            }

            public void mouseExited(MouseEvent e) {
                NotificationWindow.this.startAutoHideTimer();
            }
        });
        this.addAnimatedWindowListener(new AnimatedWindowListener(){

            public void animationCompleted(AnimatedWindowEvent event) {
                if (event.getAnimationType() == AnimatedWindow.AnimationType.SHOW) {
                    if (NotificationWindow.this.pendingScreenUpdate) {
                        NotificationWindow.this.pendingScreenUpdate = false;
                        NotificationWindow.this.doNotificationLayout();
                    }
                    NotificationWindow.this.startAutoHideTimer();
                }
            }

            public void animationStarted(AnimatedWindowEvent event) {
            }

            public void animationStopped(AnimatedWindowEvent event) {
            }
        });
    }

    public NotificationWindow(Window parent) {
        this(parent, new DefaultComboBoxModel());
    }

    public void addNotify() {
        super.addNotify();
        SystemUtils.setWindowTopMost(this);
    }

    public void addNotification(Object notification) {
        ((MutableComboBoxModel)this.model).addElement(notification);
    }

    private void doNotificationLayout() {
        if (this.isHideAnimationInProgress()) {
            this.pendingScreenUpdate = true;
            this.doShow();
            return;
        }
        if (this.isShowAnimationInProgress()) {
            this.pendingScreenUpdate = true;
            return;
        }
        this.titleLabel.setIcon(this.getIcon());
        this.titleLabel.setText(this.getTitle());
        this.setInitialHeight(this.titleLabel.getPreferredSize().height + 10);
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex != -1) {
            this.notificationIndexLabel.setText(selectedIndex + 1 + " of " + this.getModel().getSize());
            this.previousNotificationAction.setEnabled(selectedIndex > 0);
            this.nextNotificationAction.setEnabled(selectedIndex < this.getNotficationCount() - 1);
        } else {
            this.notificationIndexLabel.setText("");
            this.previousNotificationAction.setEnabled(false);
            this.nextNotificationAction.setEnabled(false);
        }
        Component component = this.getRenderer().getNotificationRendererComponent(this, this.model.getSelectedItem(), selectedIndex);
        this.mainPanel.add(component, "Center");
        this.pack();
        this.ensureVisibility();
    }

    public Point getFinalLocation() {
        AnimatedWindow.AnimationMode mode;
        Rectangle screenBounds;
        Insets screenInsets;
        Point parentLocation = new Point(this.getParentLocation() != null ? this.getParentLocation() : this.getDefaultParentLocation());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.getGraphicsConfiguration(parentLocation);
        if (gc != null) {
            screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
        } else {
            screenInsets = new Insets(0, 0, 0, 0);
            screenBounds = new Rectangle(toolkit.getScreenSize());
        }
        int screenWidth = screenBounds.width - Math.abs(screenInsets.left + screenInsets.right);
        int screenHeight = screenBounds.height - Math.abs(screenInsets.top + screenInsets.bottom);
        Dimension parentSize = new Dimension(this.getParentSize() != null ? this.getParentSize() : this.getDefaultParentSize());
        parentLocation.x -= this.getLocationOffset().width;
        parentLocation.y -= this.getLocationOffset().height;
        parentSize.width += this.getLocationOffset().width * 2;
        parentSize.height += this.getLocationOffset().height * 2;
        Dimension preferredSize = this.getPreferredSize();
        Point location = new Point();
        if (parentLocation.y - preferredSize.height > 0) {
            mode = AnimatedWindow.AnimationMode.BOTTOM_TO_TOP;
            location.y = parentLocation.y - preferredSize.height;
        } else {
            mode = AnimatedWindow.AnimationMode.TOP_TO_BOTTOM;
            location.y = parentLocation.y + parentSize.height;
        }
        location.x = parentLocation.x;
        if (location.x + preferredSize.width > screenBounds.x + screenWidth) {
            location.x = screenBounds.x + screenWidth - preferredSize.width - 1;
        }
        if (location.y + preferredSize.height > screenBounds.y + screenHeight) {
            location.y = screenBounds.y + screenHeight - preferredSize.height - 1;
        }
        if (location.x < screenBounds.x) {
            location.x = screenBounds.x;
        }
        if (location.y < screenBounds.y) {
            location.y = screenBounds.y;
        }
        if (OSUtils.isMacOSX()) {
            this.setMode(AnimatedWindow.AnimationMode.FADE);
        } else {
            this.setMode(mode);
        }
        return location;
    }

    private GraphicsConfiguration getGraphicsConfiguration(Point location) {
        GraphicsDevice[] screenDevices;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice screenDevice : screenDevices = ge.getScreenDevices()) {
            GraphicsConfiguration gc;
            if (screenDevice.getType() != 0 || !(gc = screenDevice.getDefaultConfiguration()).getBounds().contains(location)) continue;
            return gc;
        }
        return null;
    }

    private void ensureVisibility() {
        if (!this.isVisible()) {
            return;
        }
        this.setLocation(this.getFinalLocation());
    }

    public int getAutoHideTimeout() {
        return this.autoHideTimer.getDelay();
    }

    public Point getDefaultParentLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point(screenSize.width - 1, screenSize.height - 1);
    }

    public Dimension getDefaultParentSize() {
        return new Dimension(0, 0);
    }

    public Icon getIcon() {
        return this.titleIcon;
    }

    public Dimension getLocationOffset() {
        return this.locationOffset;
    }

    public ComboBoxModel getModel() {
        return this.model;
    }

    public int getNotficationCount() {
        return this.model.getSize();
    }

    public Point getParentLocation() {
        return this.parentLocation;
    }

    public Dimension getParentSize() {
        return this.parentSize;
    }

    public NotificationRenderer getRenderer() {
        return this.renderer;
    }

    public int getSelectedIndex() {
        Object selectedItem = this.model.getSelectedItem();
        int size = this.model.getSize();
        for (int i = 0; i < size; ++i) {
            Object item = this.model.getElementAt(i);
            if (item == null || !item.equals(selectedItem)) continue;
            return i;
        }
        return -1;
    }

    public Object getSelectedNotification() {
        return this.model.getSelectedItem();
    }

    public String getTitle() {
        return this.title;
    }

    public void hideWindow() {
        this.doHide();
    }

    private void initialize() {
        this.setAlwaysOnTop(true);
        this.mainPanel = new MainPanel(new BorderLayout(0, 10));
        this.mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 2), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.mainPanel.setOpaque(true);
        this.setContentPane(this.mainPanel);
        this.topPanel = new BoxPanel(0);
        this.topPanel.setOpaque(false);
        this.mainPanel.add((Component)this.topPanel, "North");
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(new Font("SansSerif", 1, 12));
        this.topPanel.add(this.titleLabel);
        this.topPanel.add(Box.createHorizontalStrut(10));
        this.topPanel.add(Box.createHorizontalGlue());
        IconButton previousNotificationButton = new IconButton(this.previousNotificationAction);
        previousNotificationButton.setIcon(GUIMediator.getThemeImage("notification-back_up.gif"));
        previousNotificationButton.setPressedIcon(GUIMediator.getThemeImage("notification-back_dn.gif"));
        this.topPanel.add(previousNotificationButton);
        this.topPanel.add(Box.createHorizontalStrut(3));
        this.notificationIndexLabel = new JLabel();
        this.notificationIndexLabel.setFont(new Font("SansSerif", 0, 12));
        this.topPanel.add(this.notificationIndexLabel);
        this.topPanel.add(Box.createHorizontalStrut(3));
        IconButton nextNotificationButton = new IconButton(this.nextNotificationAction);
        nextNotificationButton.setIcon(GUIMediator.getThemeImage("notification-forward_up.gif"));
        nextNotificationButton.setPressedIcon(GUIMediator.getThemeImage("notification-forward_dn.gif"));
        this.topPanel.add(nextNotificationButton);
        this.topPanel.add(Box.createHorizontalStrut(5));
        IconButton closeButton = new IconButton(this.closeAction);
        closeButton.setIcon(GUIMediator.getThemeImage("kill.gif"));
        closeButton.setRolloverIcon(GUIMediator.getThemeImage("kill_on.gif"));
        this.topPanel.add(closeButton);
    }

    public void removeAllNotifications() {
        if (this.model instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)this.model).removeAllElements();
        } else {
            MutableComboBoxModel mutableModel = (MutableComboBoxModel)this.model;
            int size = this.model.getSize();
            for (int i = 0; i < size; ++i) {
                Object item = this.model.getElementAt(0);
                mutableModel.removeElement(item);
            }
        }
    }

    public void removeNotification(Object notification) {
        ((MutableComboBoxModel)this.model).removeElement(notification);
    }

    public void setAutoHideTimeout(int timeout) {
        this.autoHideTimer.setDelay(timeout);
    }

    public void setLocationOffset(Dimension locationOffset) {
        this.locationOffset = locationOffset;
    }

    public void setIcon(Icon icon) {
        this.titleIcon = icon;
        this.doNotificationLayout();
    }

    public void setModel(ComboBoxModel model) {
        ComboBoxModel oldModel = this.model;
        if (oldModel != null) {
            oldModel.removeListDataListener(this.modelListener);
        }
        this.model = model;
        model.addListDataListener(this.modelListener);
        this.firePropertyChange("model", oldModel, model);
    }

    public void setParentLocation(Point parentLocation) {
        this.parentLocation = parentLocation;
    }

    public void setParentSize(Dimension parentSize) {
        this.parentSize = parentSize;
    }

    public void setRenderer(NotificationRenderer renderer) {
        this.renderer = renderer;
    }

    public void setSelectedNotification(Object notification) {
        this.model.setSelectedItem(notification);
    }

    public void setTitle(String title) {
        this.title = title;
        this.doNotificationLayout();
    }

    public void showWindow() {
        if (this.isVisible()) {
            return;
        }
        this.doShow();
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this.removeAllNotifications();
            this.stopAutoHideTimer();
        }
        super.setVisible(visible);
    }

    public void showNextNotificationOrHideWindow() {
        if (!this.showNextNotification()) {
            this.doHide();
        }
    }

    public boolean showNextNotification() {
        int i = this.getSelectedIndex();
        if (i != -1 && i < this.getNotficationCount() - 1) {
            this.model.setSelectedItem(this.model.getElementAt(i + 1));
            return true;
        }
        return false;
    }

    public boolean showPreviousNotification() {
        int i = this.getSelectedIndex();
        if (i != -1 && i > 0) {
            this.model.setSelectedItem(this.model.getElementAt(i - 1));
            return true;
        }
        return false;
    }

    public void startAutoHideTimer() {
        this.autoHideTimer.start();
    }

    public void stopAutoHideTimer() {
        this.autoHideTimer.stop();
    }

    public class MainPanel
    extends JPanel {
        private Ditherer DITHERER;

        public MainPanel(LayoutManager layoutManager) {
            super(layoutManager);
            this.DITHERER = new Ditherer(62, ThemeFileHandler.SEARCH_PANEL_BG_1.getValue(), ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
        }

        protected void paintComponent(Graphics g) {
            if (!this.DITHERER.getFromColor().equals(this.DITHERER.getToColor())) {
                Dimension size = this.getSize();
                this.DITHERER.draw(g, size.height, size.width);
            } else {
                super.paintComponent(g);
            }
        }

        public void updateUI() {
            super.updateUI();
            this.DITHERER = new Ditherer(62, ThemeFileHandler.SEARCH_PANEL_BG_1.getValue(), ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
            this.setBackground(ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("Name", "X");
        }

        public void actionPerformed(ActionEvent e) {
            NotificationWindow.this.hideWindowImmediately();
        }
    }

    private class PreviousNotificationAction
    extends AbstractAction {
        public PreviousNotificationAction() {
            this.putValue("Name", "<");
        }

        public void actionPerformed(ActionEvent e) {
            NotificationWindow.this.showPreviousNotification();
        }
    }

    private class NextNotificationAction
    extends AbstractAction {
        public NextNotificationAction() {
            this.putValue("Name", ">");
        }

        public void actionPerformed(ActionEvent e) {
            NotificationWindow.this.showNextNotification();
        }
    }

    private class ModelListener
    implements ListDataListener {
        private ModelListener() {
        }

        public void contentsChanged(ListDataEvent e) {
            NotificationWindow.this.doNotificationLayout();
        }

        public void intervalAdded(ListDataEvent e) {
            NotificationWindow.this.doNotificationLayout();
        }

        public void intervalRemoved(ListDataEvent e) {
            NotificationWindow.this.doNotificationLayout();
        }
    }

    private class IconButton
    extends JButton {
        public IconButton(Action action) {
            super(action);
            this.setText("");
        }

        public void updateUI() {
            super.updateUI();
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusable(false);
            if (this.getIcon() != null) {
                this.setPreferredSize(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
            } else {
                this.setPreferredSize(null);
            }
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }
}

