/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.notify.BasicNotifier;
import com.limegroup.gnutella.gui.notify.GrowlNotifier;
import com.limegroup.gnutella.gui.notify.JDICNotifier;
import com.limegroup.gnutella.gui.notify.Notification;
import com.limegroup.gnutella.gui.notify.NotifyUser;
import com.limegroup.gnutella.settings.UISettings;
import org.limewire.util.OSUtils;

public class NotifyUserProxy
implements NotifyUser {
    private static final NotifyUserProxy INSTANCE = new NotifyUserProxy();
    private NotifyUser _notifier;
    private boolean _inTray;

    public static NotifyUserProxy instance() {
        return INSTANCE;
    }

    private NotifyUserProxy() {
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayLibraryLoaded()) {
            this._notifier = new JDICNotifier();
            if (!this.showTrayIcon()) {
                this._notifier = new BasicNotifier();
            }
        } else {
            this._notifier = OSUtils.isMacOSX() ? new GrowlNotifier() : new BasicNotifier();
        }
    }

    public boolean supportsSystemTray() {
        return this._notifier.supportsSystemTray();
    }

    public boolean showTrayIcon() {
        if (this._inTray) {
            return true;
        }
        boolean notify = this._notifier.showTrayIcon();
        this._inTray = true;
        return notify;
    }

    public void hideTrayIcon() {
        if (!this._inTray) {
            return;
        }
        this._notifier.hideTrayIcon();
        this._inTray = false;
    }

    public void updateUI() {
        this._notifier.updateUI();
    }

    public void hideMessage(Notification notification) {
        this._notifier.hideMessage(notification);
    }

    public void showMessage(Notification notification) {
        if (!UISettings.SHOW_NOTIFICATIONS.getValue()) {
            return;
        }
        this._notifier.showMessage(notification);
    }
}

