/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.bittorrent.gui.options.panes.AutoStartTorrentsPaneItem;
import com.limegroup.bittorrent.gui.options.panes.BittorrentPaneItem;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.IconTextField;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.options.OptionsButtonPanel;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.OptionsPaneManager;
import com.limegroup.gnutella.gui.options.OptionsTreeManager;
import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.options.panes.AllowMessagesPaneItem;
import com.limegroup.gnutella.gui.options.panes.AssociationPreferencePaneItem;
import com.limegroup.gnutella.gui.options.panes.AudioPlayerPaneItem;
import com.limegroup.gnutella.gui.options.panes.AutoClearDownloadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.AutoClearUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.AutoCompletePaneItem;
import com.limegroup.gnutella.gui.options.panes.BrowserPaneItem;
import com.limegroup.gnutella.gui.options.panes.BugsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ChatActivePaneItem;
import com.limegroup.gnutella.gui.options.panes.ConnectOnStartupPaneItem;
import com.limegroup.gnutella.gui.options.panes.ConnectionPreferencingPaneItem;
import com.limegroup.gnutella.gui.options.panes.ContentFilterPaneItem;
import com.limegroup.gnutella.gui.options.panes.DaapBufferSizePaneItem;
import com.limegroup.gnutella.gui.options.panes.DaapPasswordPaneItem;
import com.limegroup.gnutella.gui.options.panes.DaapSupportPaneItem;
import com.limegroup.gnutella.gui.options.panes.DefaultActionPaneItem;
import com.limegroup.gnutella.gui.options.panes.DisableCapabilitiesPaneItem;
import com.limegroup.gnutella.gui.options.panes.DisableOOBSearchingPaneItem;
import com.limegroup.gnutella.gui.options.panes.DownloadBandwidthPaneItem;
import com.limegroup.gnutella.gui.options.panes.DownloadLicenseWarningPaneItem;
import com.limegroup.gnutella.gui.options.panes.EnableSpamFilterPaneItem;
import com.limegroup.gnutella.gui.options.panes.FileTypePaneItem;
import com.limegroup.gnutella.gui.options.panes.ForceIPPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreMessagesPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreResultTypesPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreResultsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ImageViewerPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumDownloadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumSearchesPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.NetworkInterfacePaneItem;
import com.limegroup.gnutella.gui.options.panes.NotificationsPaneItem;
import com.limegroup.gnutella.gui.options.panes.PartialFileSharingPaneItem;
import com.limegroup.gnutella.gui.options.panes.PerPersonUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.PlayerPreferencePaneItem;
import com.limegroup.gnutella.gui.options.panes.PopupsPaneItem;
import com.limegroup.gnutella.gui.options.panes.PortPaneItem;
import com.limegroup.gnutella.gui.options.panes.PromotionalSearchPaneItem;
import com.limegroup.gnutella.gui.options.panes.ProxyLoginPaneItem;
import com.limegroup.gnutella.gui.options.panes.ProxyPaneItem;
import com.limegroup.gnutella.gui.options.panes.PurgeIncompletePaneItem;
import com.limegroup.gnutella.gui.options.panes.SaveDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.SearchQualityPaneItem;
import com.limegroup.gnutella.gui.options.panes.SearchSpeedPaneItem;
import com.limegroup.gnutella.gui.options.panes.ShareSpeciallyPaneItem;
import com.limegroup.gnutella.gui.options.panes.ShareTorrentMetaPaneItem;
import com.limegroup.gnutella.gui.options.panes.SharedDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.ShutdownPaneItem;
import com.limegroup.gnutella.gui.options.panes.SpamFilterSensivityPaneItem;
import com.limegroup.gnutella.gui.options.panes.SpeedPaneItem;
import com.limegroup.gnutella.gui.options.panes.StartupPaneItem;
import com.limegroup.gnutella.gui.options.panes.StatusBarBandwidthPaneItem;
import com.limegroup.gnutella.gui.options.panes.StatusBarConnectionQualityPaneItem;
import com.limegroup.gnutella.gui.options.panes.StatusBarFirewallPaneItem;
import com.limegroup.gnutella.gui.options.panes.StatusBarLWSPaneItem;
import com.limegroup.gnutella.gui.options.panes.StatusBarSharedFilesPaneItem;
import com.limegroup.gnutella.gui.options.panes.StoreFileNamePaneItem;
import com.limegroup.gnutella.gui.options.panes.StoreSaveDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.TrayIconDisplayPaneItem;
import com.limegroup.gnutella.gui.options.panes.UpdatePaneItem;
import com.limegroup.gnutella.gui.options.panes.UploadBandwidthPaneItem;
import com.limegroup.gnutella.gui.options.panes.VideoPlayerPaneItem;
import com.limegroup.gnutella.gui.options.panes.iTunesPreferencePaneItem;
import com.limegroup.gnutella.gui.shell.LimeAssociations;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.limewire.setting.IntSetting;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OptionsConstructor {
    private final JDialog DIALOG;
    private final OptionsTreeManager TREE_MANAGER;
    private final OptionsPaneManager PANE_MANAGER;
    private final JTextField filterTextField;
    static final String SAVE_KEY = "OPTIONS_SAVE_MAIN_TITLE";
    static final String SAVE_BASIC_KEY = "OPTIONS_SAVE_BASIC_MAIN_TITLE";
    static final String SAVE_ADVANCED_KEY = "OPTIONS_SAVE_ADVANCED_MAIN_TITLE";
    public static final String SHARED_KEY = "OPTIONS_SHARED_MAIN_TITLE";
    static final String SHARED_BASIC_KEY = "OPTIONS_SHARED_BASIC_TITLE";
    static final String SHARED_ADVANCED_KEY = "OPTIONS_SHARED_ADVANCED_MAIN_TITLE";
    static final String SHARED_TYPES_KEY = "OPTIONS_SHARED_TYPES_MAIN_TITLE";
    static final String SPEED_KEY = "OPTIONS_SPEED_MAIN_TITLE";
    static final String DOWNLOAD_KEY = "OPTIONS_DOWNLOAD_MAIN_TITLE";
    static final String UPLOAD_KEY = "OPTIONS_UPLOAD_MAIN_TITLE";
    static final String UPLOAD_BASIC_KEY = "OPTIONS_UPLOAD_BASIC_MAIN_TITLE";
    static final String UPLOAD_SLOTS_KEY = "OPTIONS_UPLOAD_SLOTS_MAIN_TITLE";
    static final String CONNECTIONS_KEY = "OPTIONS_CONNECTIONS_MAIN_TITLE";
    static final String BITTORRENT_KEY = "OPTIONS_BITTORRENT_MAIN_TITLE";
    static final String BITTORRENT_BASIC_KEY = "OPTIONS_BITTORRENT_BASIC_TITLE";
    static final String BITTORRENT_ADVANCED_KEY = "OPTIONS_BITTORRENT_ADVANCED_TITLE";
    static final String SHUTDOWN_KEY = "OPTIONS_SHUTDOWN_MAIN_TITLE";
    static final String UPDATE_KEY = "OPTIONS_UPDATE_MAIN_TITLE";
    static final String CHAT_KEY = "OPTIONS_CHAT_MAIN_TITLE";
    static final String PLAYER_KEY = "OPTIONS_PLAYER_MAIN_TITLE";
    static final String STATUS_BAR_KEY = "OPTIONS_STATUS_BAR_MAIN_TITLE";
    static final String ITUNES_KEY = "OPTIONS_ITUNES_MAIN_TITLE";
    static final String ITUNES_IMPORT_KEY = "OPTIONS_ITUNES_PREFERENCE_MAIN_TITLE";
    static final String ITUNES_DAAP_KEY = "OPTIONS_ITUNES_DAAP_MAIN_TITLE";
    static final String POPUPS_KEY = "OPTIONS_POPUPS_MAIN_TITLE";
    static final String BUGS_KEY = "OPTIONS_BUGS_MAIN_TITLE";
    static final String APPS_KEY = "OPTIONS_APPS_MAIN_TITLE";
    static final String SEARCH_KEY = "OPTIONS_SEARCH_MAIN_TITLE";
    static final String SEARCH_LIMIT_KEY = "OPTIONS_SEARCH_LIMIT_MAIN_TITLE";
    static final String SEARCH_QUALITY_KEY = "OPTIONS_SEARCH_QUALITY_MAIN_TITLE";
    static final String SEARCH_SPEED_KEY = "OPTIONS_SEARCH_SPEED_MAIN_TITLE";
    public static final String CONTENT_FILTER_KEY = "OPTIONS_CONTENT_FILTER_MAIN_TITLE";
    static final String SEARCH_JUNK_KEY = "OPTIONS_SEARCH_JUNK_MAIN_TITLE";
    static final String FILTERS_KEY = "OPTIONS_FILTERS_MAIN_TITLE";
    static final String RESULTS_KEY = "OPTIONS_RESULTS_MAIN_TITLE";
    static final String MESSAGES_KEY = "OPTIONS_MESSAGES_MAIN_TITLE";
    static final String ADVANCED_KEY = "OPTIONS_ADVANCED_MAIN_TITLE";
    static final String PREFERENCING_KEY = "OPTIONS_PREFERENCING_MAIN_TITLE";
    static final String FIREWALL_KEY = "OPTIONS_FIREWALL_MAIN_TITLE";
    static final String GUI_KEY = "OPTIONS_GUI_MAIN_TITLE";
    static final String AUTOCOMPLETE_KEY = "OPTIONS_AUTOCOMPLETE_MAIN_TITLE";
    static final String STARTUP_KEY = "OPTIONS_STARTUP_MAIN_TITLE";
    static final String PROXY_KEY = "OPTIONS_PROXY_MAIN_TITLE";
    static final String NETWORK_INTERFACE_KEY = "OPTIONS_NETWORK_INTERFACE_MAIN_TITLE";
    static final String ASSOCIATIONS_KEY = "OPTIONS_ASSOCIATIONS_MAIN_TITLE";
    static final String PERFORMANCE_KEY = "OPTIONS_PERFORMANCE_MAIN_TITLE";
    static final String STORE_KEY = "OPTIONS_STORE_MAIN_TITLE";
    static final String STORE_BASIC_KEY = "OPTIONS_STORE_BASIC_MAIN_TITLE";
    static final String STORE_ADVANCED_KEY = "OPTIONS_STORE_ADVANCED_MAIN_TITLE";

    public OptionsConstructor(OptionsTreeManager treeManager, OptionsPaneManager paneManager) {
        this.TREE_MANAGER = treeManager;
        this.PANE_MANAGER = paneManager;
        String title = I18n.tr("Options");
        boolean shouldBeModal = !OSUtils.isMacOSX();
        this.DIALOG = new JDialog(GUIMediator.getAppFrame(), title, shouldBeModal);
        this.DIALOG.setDefaultCloseOperation(0);
        GUIUtils.addHideAction((JComponent)this.DIALOG.getContentPane());
        DialogSizeSettingUpdater.install(this.DIALOG, UISettings.UI_OPTIONS_DIALOG_WIDTH, UISettings.UI_OPTIONS_DIALOG_HEIGHT);
        this.DIALOG.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    DialogOption answer = null;
                    if (OptionsMediator.instance().isDirty() && (answer = GUIMediator.showYesNoCancelMessage(I18n.tr("You have made changes to some of LimeWire's settings. Would you like to save these changes?"))) == DialogOption.YES) {
                        OptionsMediator.instance().applyOptions();
                        SettingsGroupManager.instance().save();
                    }
                    if (answer != DialogOption.CANCEL) {
                        OptionsConstructor.this.DIALOG.dispose();
                        OptionsMediator.instance().disposeOptions();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        PaddedPanel mainPanel = new PaddedPanel();
        Box splitBox = new Box(0);
        BoxPanel treePanel = new BoxPanel(1);
        BoxPanel filterPanel = new BoxPanel(0);
        treePanel.add(filterPanel);
        IconTextField iconTextField = new IconTextField((Icon)GUIMediator.getThemeImage("browse_host_generic"), 10);
        this.filterTextField = iconTextField.getTextField();
        this.filterTextField.setText(I18n.tr("Search here"));
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent event) {
                OptionsConstructor.this.filter();
            }

            public void insertUpdate(DocumentEvent e) {
                OptionsConstructor.this.filter();
            }

            public void removeUpdate(DocumentEvent e) {
                OptionsConstructor.this.filter();
            }
        });
        this.filterTextField.setForeground(Color.lightGray);
        this.filterTextField.addFocusListener(new FocusAdapter(){
            private boolean initialized = false;

            public void focusGained(FocusEvent e) {
                if (this.initialized) {
                    return;
                }
                OptionsConstructor.this.filterTextField.setForeground(UIManager.getColor("TextField.foreground"));
                OptionsConstructor.this.filterTextField.setText("");
                this.initialized = true;
            }
        });
        filterPanel.add(iconTextField);
        filterPanel.add(Box.createHorizontalStrut(2));
        IconButton eraseButton = new IconButton("CLEAR_TEXT");
        eraseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsConstructor.this.filterTextField.setText("");
            }
        });
        filterPanel.add(eraseButton);
        treePanel.add(Box.createVerticalStrut(3));
        Component treeComponent = this.TREE_MANAGER.getComponent();
        treePanel.add(treeComponent);
        Component paneComponent = this.PANE_MANAGER.getComponent();
        splitBox.add(treePanel);
        splitBox.add(paneComponent);
        mainPanel.add(splitBox);
        mainPanel.add(Box.createVerticalStrut(17));
        mainPanel.add(new OptionsButtonPanel().getComponent());
        this.DIALOG.getContentPane().add(mainPanel);
        OptionsTreeNode node = this.initializePanels();
        this.PANE_MANAGER.show(node);
    }

    private OptionsTreeNode initializePanels() {
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", SAVE_KEY, I18n.tr("Saving"));
        OptionsTreeNode node = this.addOption(SAVE_KEY, SAVE_BASIC_KEY, I18n.tr("Basic"), SaveDirPaneItem.class, PurgeIncompletePaneItem.class);
        this.addOption(SAVE_KEY, SAVE_ADVANCED_KEY, I18n.tr("Advanced"), DefaultActionPaneItem.class);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", SHARED_KEY, I18n.tr("Sharing"));
        this.addOption(SHARED_KEY, SHARED_BASIC_KEY, I18n.tr("Basic"), SharedDirPaneItem.class, ShareSpeciallyPaneItem.class);
        this.addOption(SHARED_KEY, SHARED_ADVANCED_KEY, I18n.tr("Advanced"), ShareTorrentMetaPaneItem.class, PartialFileSharingPaneItem.class);
        this.addOption(SHARED_KEY, SHARED_TYPES_KEY, I18n.tr("Types"), FileTypePaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", STORE_KEY, I18n.tr("LimeWire Store"), StoreSaveDirPaneItem.class, StoreFileNamePaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", SPEED_KEY, I18n.tr("Speed"), SpeedPaneItem.class, DisableOOBSearchingPaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", DOWNLOAD_KEY, I18n.tr("Downloads"), MaximumDownloadsPaneItem.class, AutoClearDownloadsPaneItem.class, DownloadBandwidthPaneItem.class);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", UPLOAD_KEY, I18n.tr("Uploads"));
        this.addOption(UPLOAD_KEY, UPLOAD_BASIC_KEY, I18n.tr("Basic"), AutoClearUploadsPaneItem.class, UploadBandwidthPaneItem.class);
        this.addOption(UPLOAD_KEY, UPLOAD_SLOTS_KEY, I18n.tr("Slots"), PerPersonUploadsPaneItem.class, MaximumUploadsPaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", CONNECTIONS_KEY, I18n.tr("Connections"), ConnectOnStartupPaneItem.class);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", BITTORRENT_KEY, I18n.tr("BitTorrent"));
        this.addOption(BITTORRENT_KEY, BITTORRENT_BASIC_KEY, I18n.tr("Basic"), AutoStartTorrentsPaneItem.class);
        this.addOption(BITTORRENT_KEY, BITTORRENT_ADVANCED_KEY, I18n.tr("Advanced"), BittorrentPaneItem.class);
        Class[] clazzes = OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable() ? new Class[]{ShutdownPaneItem.class, TrayIconDisplayPaneItem.class} : new Class[]{ShutdownPaneItem.class};
        this.addOption("OPTIONS_ROOT_NODE", SHUTDOWN_KEY, I18n.tr("System Tray"), clazzes);
        this.addOption("OPTIONS_ROOT_NODE", UPDATE_KEY, I18n.tr("Updates"), UpdatePaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", CHAT_KEY, I18n.tr("Chat"), ChatActivePaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", PLAYER_KEY, I18n.tr("Player"), PlayerPreferencePaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", STATUS_BAR_KEY, I18n.tr("Status Bar"), StatusBarConnectionQualityPaneItem.class, StatusBarFirewallPaneItem.class, StatusBarSharedFilesPaneItem.class, StatusBarBandwidthPaneItem.class, StatusBarLWSPaneItem.class);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", ITUNES_KEY, I18n.tr("iTunes"));
        if (OSUtils.isMacOSX()) {
            this.addOption(ITUNES_KEY, ITUNES_IMPORT_KEY, I18n.tr("Importing"), iTunesPreferencePaneItem.class);
        }
        this.addOption(ITUNES_KEY, ITUNES_DAAP_KEY, I18n.tr("Sharing"), DaapSupportPaneItem.class, DaapPasswordPaneItem.class, DaapBufferSizePaneItem.class);
        if (!OSUtils.isWindows() && !OSUtils.isAnyMac()) {
            this.addOption("OPTIONS_ROOT_NODE", APPS_KEY, I18n.tr("Helper Apps"), BrowserPaneItem.class, ImageViewerPaneItem.class, VideoPlayerPaneItem.class, AudioPlayerPaneItem.class);
        }
        this.addOption("OPTIONS_ROOT_NODE", BUGS_KEY, I18n.tr("Bug Reports"), BugsPaneItem.class);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", GUI_KEY, I18n.tr("View"));
        this.addOption(GUI_KEY, POPUPS_KEY, I18n.tr("Popups"), PopupsPaneItem.class, NotificationsPaneItem.class);
        this.addOption(GUI_KEY, AUTOCOMPLETE_KEY, I18n.tr("Autocomplete"), AutoCompletePaneItem.class);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", SEARCH_KEY, I18n.tr("Searching"));
        if (LimeWireUtils.isPro()) {
            this.addOption(SEARCH_KEY, SEARCH_LIMIT_KEY, I18n.tr("Basic"), MaximumSearchesPaneItem.class, DownloadLicenseWarningPaneItem.class, PromotionalSearchPaneItem.class);
        } else {
            this.addOption(SEARCH_KEY, SEARCH_LIMIT_KEY, I18n.tr("Basic"), MaximumSearchesPaneItem.class, DownloadLicenseWarningPaneItem.class);
        }
        this.addOption(SEARCH_KEY, SEARCH_QUALITY_KEY, I18n.tr("Quality"), SearchQualityPaneItem.class);
        this.addOption(SEARCH_KEY, SEARCH_SPEED_KEY, I18n.tr("Speed"), SearchSpeedPaneItem.class);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", FILTERS_KEY, I18n.tr("Filters"));
        this.addOption(FILTERS_KEY, CONTENT_FILTER_KEY, I18n.tr("Content"), ContentFilterPaneItem.class);
        this.addOption(FILTERS_KEY, SEARCH_JUNK_KEY, I18n.tr("Junk"), EnableSpamFilterPaneItem.class, SpamFilterSensivityPaneItem.class);
        this.addOption(FILTERS_KEY, RESULTS_KEY, I18n.tr("Keywords"), IgnoreResultsPaneItem.class, IgnoreResultTypesPaneItem.class);
        this.addOption(FILTERS_KEY, MESSAGES_KEY, I18n.tr("Hosts"), IgnoreMessagesPaneItem.class, AllowMessagesPaneItem.class);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", ADVANCED_KEY, I18n.tr("Advanced"));
        this.addOption(ADVANCED_KEY, PREFERENCING_KEY, I18n.tr("Preferencing"), ConnectionPreferencingPaneItem.class);
        this.addOption(ADVANCED_KEY, FIREWALL_KEY, I18n.tr("Firewall"), PortPaneItem.class, ForceIPPaneItem.class);
        this.addOption(ADVANCED_KEY, PROXY_KEY, I18n.tr("Proxy"), ProxyPaneItem.class, ProxyLoginPaneItem.class);
        this.addOption(ADVANCED_KEY, NETWORK_INTERFACE_KEY, I18n.tr("Network Interface"), NetworkInterfacePaneItem.class);
        if (LimeAssociations.anyAssociationsSupported()) {
            this.addOption(ADVANCED_KEY, ASSOCIATIONS_KEY, I18n.tr("File Associations"), AssociationPreferencePaneItem.class);
        }
        this.addOption(ADVANCED_KEY, PERFORMANCE_KEY, I18n.tr("Performance"), DisableCapabilitiesPaneItem.class);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            this.addOption(ADVANCED_KEY, STARTUP_KEY, I18n.tr("System Boot"), StartupPaneItem.class);
        }
        return node;
    }

    private final void addGroupTreeNode(String parentKey, String childKey, String label) {
        this.TREE_MANAGER.addNode(parentKey, childKey, label, label);
    }

    private final OptionsTreeNode addOption(String parentKey, String childKey, String label, Class<? extends AbstractPaneItem> ... clazzes) {
        StringBuilder sb = new StringBuilder();
        sb.append(label);
        sb.append(" ");
        sb.append(this.extractLabels(clazzes));
        OptionsTreeNode node = this.TREE_MANAGER.addNode(parentKey, childKey, label, sb.toString());
        node.setClasses(clazzes);
        return node;
    }

    private String extractLabels(Class<?> ... clazzes) {
        StringBuilder sb = new StringBuilder();
        for (Class<?> clazz : clazzes) {
            Field[] fields;
            for (Field field : fields = clazz.getFields()) {
                if ((field.getModifiers() & 0x10) == 0 || field.getType() != String.class) continue;
                try {
                    sb.append(field.get(null));
                    sb.append(" ");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return sb.toString();
    }

    final void setOptionsVisible(boolean visible, String key) {
        if (!visible) {
            this.DIALOG.dispose();
            OptionsMediator.instance().disposeOptions();
        } else {
            GUIUtils.centerOnScreen(this.DIALOG);
            if (key == null) {
                this.TREE_MANAGER.setDefaultSelection();
            } else {
                this.TREE_MANAGER.setSelection(key);
            }
            this.TREE_MANAGER.getComponent().requestFocusInWindow();
            this.DIALOG.setVisible(true);
        }
    }

    public final boolean isOptionsVisible() {
        return this.DIALOG.isVisible();
    }

    JDialog getMainOptionsComponent() {
        return this.DIALOG;
    }

    private void filter() {
        this.TREE_MANAGER.setFilterText(this.filterTextField.getText());
    }

    public static class DialogSizeSettingUpdater {
        public static void install(JDialog dialog, IntSetting widthSetting, IntSetting heightSetting) {
            int increment = ThemeSettings.FONT_SIZE_INCREMENT.getValue();
            int width = widthSetting.isDefault() ? DialogSizeSettingUpdater.getWidthForFontIncrement(widthSetting, dialog, increment) : widthSetting.getValue();
            int height = heightSetting.isDefault() ? DialogSizeSettingUpdater.getHeightForFontIncrement(heightSetting, dialog, increment) : heightSetting.getValue();
            dialog.setSize(width, height);
            dialog.addComponentListener(new SizeChangeListener(widthSetting, heightSetting));
        }

        private static int getWidthForFontIncrement(IntSetting widthSetting, Component component, int increment) {
            if (increment > 0) {
                return widthSetting.getValue() + 20 * increment + 4 * increment ^ 2;
            }
            return widthSetting.getValue();
        }

        private static int getHeightForFontIncrement(IntSetting heightSetting, Component component, int increment) {
            if (increment > 0) {
                return heightSetting.getValue() + 10 * increment + 18 * increment ^ 2;
            }
            return heightSetting.getValue();
        }

        private static class SizeChangeListener
        extends ComponentAdapter {
            private IntSetting widthSetting;
            private IntSetting heightSetting;

            public SizeChangeListener(IntSetting widthSetting, IntSetting heightSetting) {
                this.widthSetting = widthSetting;
                this.heightSetting = heightSetting;
            }

            public void componentResized(ComponentEvent e) {
                int increment = ThemeSettings.FONT_SIZE_INCREMENT.getValue();
                Component c = e.getComponent();
                if (c.getWidth() != DialogSizeSettingUpdater.getWidthForFontIncrement(this.widthSetting, c, increment) || c.getHeight() != DialogSizeSettingUpdater.getHeightForFontIncrement(this.heightSetting, c, increment)) {
                    this.widthSetting.setValue(c.getWidth());
                    this.heightSetting.setValue(c.getHeight());
                }
            }
        }
    }
}

