/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public abstract class AbstractDirPaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = I18nMarker.marktr("Folder:");
    protected final JTextField saveField = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
    protected String saveDirectory;

    public AbstractDirPaneItem(String title) {
        this(title, I18n.tr("You can choose the folder for saving files."));
    }

    public AbstractDirPaneItem(String title, String label) {
        super(title, label);
        LabeledComponent comp = new LabeledComponent(this.OPTION_LABEL, this.saveField);
        ButtonRow br = new ButtonRow(this.getActions(), 0, 12);
        this.add(comp.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(br);
        this.add(this.getVerticalSeparator());
    }

    private Action[] getActions() {
        return new Action[]{new SelectSaveDirectoryListener(), new DefaultListener()};
    }

    public abstract void initOptions();

    public abstract String getDefaultPath();

    public void setDirectoryPath(String path) {
        this.saveDirectory = path;
        this.saveField.setText(this.saveDirectory);
    }

    public abstract boolean applyOptions() throws IOException;

    public abstract boolean isDirty();

    private class SelectSaveDirectoryListener
    extends AbstractAction {
        public SelectSaveDirectoryListener() {
            this.putValue("Name", I18n.tr("Browse..."));
            this.putValue("ShortDescription", I18n.tr("Choose Another Folder"));
        }

        public void actionPerformed(ActionEvent e) {
            File dir = FileChooserHandler.getInputDirectory(OptionsMediator.instance().getMainOptionsComponent(), new File(AbstractDirPaneItem.this.saveDirectory));
            if (dir == null) {
                return;
            }
            SaveDirectoryHandler.ValidationResult result = SaveDirectoryHandler.isFolderValidForSaveDirectory(dir);
            switch (result) {
                case VALID: {
                    break;
                }
                case BAD_BANNED: 
                case BAD_VISTA: 
                case BAD_SENSITIVE: {
                    return;
                }
                default: {
                    GUIMediator.showError(I18n.tr("The selected save folder is invalid. You may not have permissions to write to the selected folder. LimeWire will revert to your previously selected folder."));
                    return;
                }
            }
            try {
                String newDir = dir.getCanonicalPath();
                if (!newDir.equals(AbstractDirPaneItem.this.saveDirectory)) {
                    AbstractDirPaneItem.this.saveField.setText(newDir);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    private class DefaultListener
    extends AbstractAction {
        public DefaultListener() {
            this.putValue("Name", I18n.tr("Use Default"));
            this.putValue("ShortDescription", I18n.tr("Use the Default Folder"));
        }

        public void actionPerformed(ActionEvent e) {
            AbstractDirPaneItem.this.saveField.setText(AbstractDirPaneItem.this.getDefaultPath());
        }
    }
}

