/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.TitledPaddedPanel;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.options.panes.PaneItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.Box;

public abstract class AbstractPaneItem
implements PaneItem {
    private final TitledPaddedPanel CONTAINER = new TitledPaddedPanel();
    private final int LABEL_WIDTH = 415;

    protected AbstractPaneItem(String title, String text) {
        this(title, text, null);
    }

    protected AbstractPaneItem(String title, String text, String url) {
        this.CONTAINER.setTitle(title);
        this.add(Box.createHorizontalGlue());
        MultiLineLabel label = new MultiLineLabel(text, 415, true);
        GUIUtils.restrictSize(label, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
        this.add(label);
        this.add(this.getVerticalSeparator());
        if (url != null) {
            this.add(new URLLabel(url, I18n.tr("Learn more about this option...")));
            this.add(this.getVerticalSeparator());
        }
    }

    protected void addLabel(String labelText) {
        MultiLineLabel label = new MultiLineLabel(labelText, 415, true);
        GUIUtils.restrictSize(label, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
        this.add(label);
    }

    public Container getContainer() {
        return this.CONTAINER;
    }

    public abstract void initOptions();

    public abstract boolean applyOptions() throws IOException;

    protected final void add(Component comp) {
        this.CONTAINER.add(comp);
    }

    protected final Component getHorizontalSeparator() {
        return Box.createRigidArea(new Dimension(6, 0));
    }

    protected final Component getVerticalSeparator() {
        return Box.createRigidArea(new Dimension(0, 6));
    }
}

