/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.shell.LimeAssociationOption;
import com.limegroup.gnutella.gui.shell.LimeAssociations;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class AssociationPreferencePaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Links and File Types");
    public static final String LABEL = I18n.tr("You can use LimeWire to open certain filetypes and protocols. You can also instruct LimeWire to always regain these associations if another program takes them.");
    private Map<JCheckBox, LimeAssociationOption> associations = new HashMap<JCheckBox, LimeAssociationOption>();
    private JRadioButton always;
    private JRadioButton never;
    private JRadioButton ask;

    public AssociationPreferencePaneItem() {
        super(TITLE, LABEL);
        Collection<LimeAssociationOption> options = LimeAssociations.getSupportedAssociations();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(5, 0, 2, 0);
        panel.add((Component)new JLabel(I18n.tr("Use LimeWire for...")), gbc);
        gbc.insets = new Insets(1, 4, 1, 0);
        for (LimeAssociationOption option : options) {
            JCheckBox box = new JCheckBox(option.getDescription());
            this.associations.put(box, option);
            panel.add((Component)box, gbc);
        }
        gbc.insets = new Insets(9, 0, 2, 0);
        panel.add((Component)new JLabel(I18n.tr("What should LimeWire do with the selected associations on startup?")), gbc);
        int value = QuestionsHandler.GRAB_ASSOCIATIONS.getValue();
        this.always = new JRadioButton(I18n.tr("Always take the selected associations."), value == DialogOption.YES.toInt());
        this.never = new JRadioButton(I18n.tr("Ignore all missing associations."), value == DialogOption.NO.toInt());
        this.ask = new JRadioButton(I18n.tr("Ask me what to do when an association is missing."), DialogOption.parseInt(value) != DialogOption.YES && DialogOption.parseInt(value) != DialogOption.NO);
        ButtonGroup grabGroup = new ButtonGroup();
        grabGroup.add(this.always);
        grabGroup.add(this.ask);
        grabGroup.add(this.never);
        gbc.insets = new Insets(1, 4, 1, 0);
        panel.add((Component)this.always, gbc);
        panel.add((Component)this.ask, gbc);
        panel.add((Component)this.never, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridheight = 0;
        panel.add(Box.createGlue(), gbc);
        this.add(panel);
    }

    public void initOptions() {
        for (JCheckBox box : this.associations.keySet()) {
            box.setSelected(this.associations.get(box).isEnabled());
        }
        DialogOption choice = DialogOption.parseInt(QuestionsHandler.GRAB_ASSOCIATIONS.getValue());
        switch (choice) {
            case YES: {
                this.always.setSelected(true);
                break;
            }
            case NO: {
                this.never.setSelected(true);
                break;
            }
            default: {
                this.ask.setSelected(true);
            }
        }
    }

    public boolean applyOptions() throws IOException {
        for (Map.Entry<JCheckBox, LimeAssociationOption> entry : this.associations.entrySet()) {
            LimeAssociationOption option = entry.getValue();
            if (entry.getKey().isSelected()) {
                option.setAllowed(true);
                option.setEnabled(true);
                continue;
            }
            if (option.isEnabled()) {
                option.setAllowed(false);
            }
            option.setEnabled(false);
        }
        DialogOption value = DialogOption.INVALID;
        if (this.always.isSelected()) {
            value = DialogOption.YES;
        } else if (this.never.isSelected()) {
            value = DialogOption.NO;
        }
        QuestionsHandler.GRAB_ASSOCIATIONS.setValue(value.toInt());
        return false;
    }

    public boolean isDirty() {
        for (Map.Entry<JCheckBox, LimeAssociationOption> option : this.associations.entrySet()) {
            if (option.getKey().isSelected() == option.getValue().isEnabled()) continue;
            return true;
        }
        switch (DialogOption.parseInt(QuestionsHandler.GRAB_ASSOCIATIONS.getValue())) {
            case YES: {
                return !this.always.isSelected();
            }
            case NO: {
                return !this.never.isSelected();
            }
        }
        return !this.ask.isSelected();
    }
}

