/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.DaapSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public final class DaapSupportPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Sharing");
    public static final String LABEL = I18n.tr("You can share your Music on the Local Area Network and make it accessible for iTunes and other Digital Audio Access Protocol (DAAP) enabled Players.");
    private final String DAAP_ENABLED_LABEL = I18nMarker.marktr("Share My Music:");
    private final String SERVICE_NAME_LABEL = I18nMarker.marktr("Shared Name:");
    private final JCheckBox DAAP_ENABLED = new JCheckBox();
    private final JTextField SERVICE_NAME = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);

    public DaapSupportPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.DAAP_ENABLED_LABEL, this.DAAP_ENABLED, 120, 10);
        this.add(comp.getComponent());
        this.add(this.getVerticalSeparator());
        comp = new LabeledComponent(this.SERVICE_NAME_LABEL, this.SERVICE_NAME);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this.DAAP_ENABLED.setSelected(DaapSettings.DAAP_ENABLED.getValue() && DaapManager.instance().isServerRunning());
        this.SERVICE_NAME.setText(DaapSettings.DAAP_SERVICE_NAME.getValue());
    }

    public boolean applyOptions() throws IOException {
        boolean prevEnabled = DaapSettings.DAAP_ENABLED.getValue();
        String prevServiceName = DaapSettings.DAAP_SERVICE_NAME.getValue();
        String serviceName = this.SERVICE_NAME.getText().trim();
        if (serviceName.length() == 0 && this.DAAP_ENABLED.isSelected()) {
            throw new IOException();
        }
        DaapSettings.DAAP_ENABLED.setValue(this.DAAP_ENABLED.isSelected());
        DaapSettings.DAAP_SERVICE_NAME.setValue(serviceName);
        DaapSettings.DAAP_LIBRARY_NAME.setValue(serviceName);
        try {
            if (this.DAAP_ENABLED.isSelected()) {
                if (!prevEnabled) {
                    DaapManager.instance().restart();
                } else if (!serviceName.equals(prevServiceName)) {
                    DaapManager.instance().updateService();
                }
            } else if (prevEnabled) {
                DaapManager.instance().stop();
            }
        }
        catch (IOException err) {
            DaapSettings.DAAP_ENABLED.setValue(prevEnabled);
            DaapSettings.DAAP_SERVICE_NAME.setValue(prevServiceName);
            DaapSettings.DAAP_LIBRARY_NAME.setValue(prevServiceName);
            DaapManager.instance().stop();
            this.initOptions();
            throw err;
        }
        return false;
    }

    public boolean isDirty() {
        return DaapSettings.DAAP_ENABLED.getValue() != this.DAAP_ENABLED.isSelected() || !DaapSettings.DAAP_SERVICE_NAME.getValue().equals(this.SERVICE_NAME.getText()) || !DaapSettings.DAAP_LIBRARY_NAME.getValue().equals(this.SERVICE_NAME.getText());
    }
}

