/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public class DownloadLicenseWarningPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("License Warning");
    public static final String LABEL = I18n.tr("You can choose whether to be warned about downloading a file without a license.");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Show License Warning:");
    private final JCheckBox CHECK_BOX = new JCheckBox();
    private int skipWarning;

    public DownloadLicenseWarningPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this.skipWarning = QuestionsHandler.SKIP_FIRST_DOWNLOAD_WARNING.getValue();
        this.CHECK_BOX.setSelected(DialogOption.parseInt(this.skipWarning) != DialogOption.YES);
    }

    public boolean applyOptions() throws IOException {
        boolean skip;
        boolean bl = skip = !this.CHECK_BOX.isSelected();
        if (skip) {
            if (DialogOption.parseInt(this.skipWarning) != DialogOption.YES) {
                QuestionsHandler.SKIP_FIRST_DOWNLOAD_WARNING.setValue(DialogOption.YES.toInt());
            }
        } else if (DialogOption.parseInt(this.skipWarning) == DialogOption.YES) {
            QuestionsHandler.SKIP_FIRST_DOWNLOAD_WARNING.setValue(0);
        }
        return false;
    }

    public boolean isDirty() {
        boolean skip;
        boolean bl = skip = !this.CHECK_BOX.isSelected();
        if (skip) {
            return DialogOption.parseInt(this.skipWarning) != DialogOption.YES;
        }
        return DialogOption.parseInt(this.skipWarning) == DialogOption.YES;
    }
}

