/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public final class EnableSpamFilterPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Display");
    public static final String LABEL = I18n.tr("You can disable LimeWire's junk filter and delete all previously collected filter data here, if your junk filter is rating too many files as spam.");
    private JRadioButton DISPLAY_IN_PLACE = new JRadioButton();
    private JRadioButton MOVE_TO_BOTTOM = new JRadioButton();
    private JRadioButton HIDE_SPAM = new JRadioButton();

    public EnableSpamFilterPaneItem() {
        super(TITLE, LABEL);
        this.DISPLAY_IN_PLACE.setText(I18n.tr("Display junk in place"));
        this.MOVE_TO_BOTTOM.setText(I18n.tr("Display junk at the bottom of search results"));
        this.HIDE_SPAM.setText(I18n.tr("Do not display junk"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.DISPLAY_IN_PLACE);
        group.add(this.MOVE_TO_BOTTOM);
        group.add(this.HIDE_SPAM);
        BoxPanel buttonPanel = new BoxPanel();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.DISPLAY_IN_PLACE);
        buttonPanel.add(this.MOVE_TO_BOTTOM);
        buttonPanel.add(this.HIDE_SPAM);
        this.add(buttonPanel);
    }

    public void initOptions() {
        switch (SearchSettings.DISPLAY_JUNK_MODE.getValue()) {
            case 0: {
                this.DISPLAY_IN_PLACE.setSelected(true);
                break;
            }
            case 2: {
                this.HIDE_SPAM.setSelected(true);
                break;
            }
            default: {
                this.MOVE_TO_BOTTOM.setSelected(true);
            }
        }
    }

    public boolean applyOptions() throws IOException {
        if (this.DISPLAY_IN_PLACE.isSelected()) {
            SearchSettings.DISPLAY_JUNK_MODE.setValue(0);
        } else if (this.HIDE_SPAM.isSelected()) {
            SearchSettings.DISPLAY_JUNK_MODE.setValue(2);
        } else {
            SearchSettings.DISPLAY_JUNK_MODE.setValue(1);
        }
        return false;
    }

    public boolean isDirty() {
        boolean modeChange = false;
        modeChange = this.DISPLAY_IN_PLACE.isSelected() ? SearchSettings.DISPLAY_JUNK_MODE.getValue() != 0 : (this.HIDE_SPAM.isSelected() ? SearchSettings.DISPLAY_JUNK_MODE.getValue() != 2 : SearchSettings.DISPLAY_JUNK_MODE.getValue() != 1);
        return modeChange;
    }
}

