/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public final class ExtensionsPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Shared Extensions");
    public static final String LABEL = I18n.tr("You can choose which file extensions you would like to share.");
    private final String OPTION_LABEL = I18nMarker.marktr("Extensions:");
    private JTextField _extField = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
    private String _extensions;

    public ExtensionsPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.OPTION_LABEL, this._extField, 150, 13);
        String[] labelKeys = new String[]{I18nMarker.marktr("Use Defaults")};
        String[] toolTipKeys = new String[]{I18nMarker.marktr("Share the Default File Extensions")};
        ActionListener[] listeners = new ActionListener[]{new DefaultExtensionsListener()};
        ButtonRow br = new ButtonRow(labelKeys, toolTipKeys, listeners, 0, 12);
        this.add(comp.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(br);
    }

    public void initOptions() {
        this._extensions = SharingSettings.EXTENSIONS_TO_SHARE.getValue();
        this._extField.setText(this._extensions);
    }

    public boolean applyOptions() throws IOException {
        String ext = this._extField.getText();
        if (!ext.equals(this._extensions)) {
            SharingSettings.EXTENSIONS_TO_SHARE.setValue(this._extField.getText());
            GuiCoreMediator.getFileManager().loadSettings();
            this._extensions = this._extField.getText();
        }
        return false;
    }

    public boolean isDirty() {
        return !SharingSettings.EXTENSIONS_TO_SHARE.getValue().equals(this._extField.getText());
    }

    private class DefaultExtensionsListener
    implements ActionListener {
        private DefaultExtensionsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SharingSettings.EXTENSIONS_TO_SHARE.revertToDefault();
            ExtensionsPaneItem.this._extField.setText(SharingSettings.EXTENSIONS_TO_SHARE.getValue());
        }
    }
}

